/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.subst.NodeToStringTransformer;
import ch.qos.logback.core.util.DynamicClassLoadingException;
import ch.qos.logback.core.util.IncompatibleClassException;
import ch.qos.logback.core.util.Loader;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class OptionHelper {
    static final String DELIM_START = "${";
    static final char DELIM_STOP = '}';
    static final String DELIM_DEFAULT = ":-";
    static final int DELIM_START_LEN = 2;
    static final int DELIM_STOP_LEN = 1;
    static final int DELIM_DEFAULT_LEN = 2;
    static final String _IS_UNDEFINED = "_IS_UNDEFINED";

    public static Object instantiateByClassName(String className, Class<?> superClass, Context context2) throws IncompatibleClassException, DynamicClassLoadingException {
        ClassLoader classLoader = Loader.getClassLoaderOfObject(context2);
        return OptionHelper.instantiateByClassName(className, superClass, classLoader);
    }

    public static Object instantiateByClassNameAndParameter(String className, Class<?> superClass, Context context2, Class<?> type, Object param2) throws IncompatibleClassException, DynamicClassLoadingException {
        ClassLoader classLoader = Loader.getClassLoaderOfObject(context2);
        return OptionHelper.instantiateByClassNameAndParameter(className, superClass, classLoader, type, param2);
    }

    public static Object instantiateByClassName(String className, Class<?> superClass, ClassLoader classLoader) throws IncompatibleClassException, DynamicClassLoadingException {
        return OptionHelper.instantiateByClassNameAndParameter(className, superClass, classLoader, null, null);
    }

    public static Object instantiateByClassNameAndParameter(String className, Class<?> superClass, ClassLoader classLoader, Class<?> type, Object parameter) throws IncompatibleClassException, DynamicClassLoadingException {
        if (className == null) {
            throw new NullPointerException();
        }
        try {
            Class<?> classObj = null;
            classObj = classLoader.loadClass(className);
            if (!superClass.isAssignableFrom(classObj)) {
                throw new IncompatibleClassException(superClass, classObj);
            }
            if (type == null) {
                return classObj.newInstance();
            }
            Constructor<?> constructor = classObj.getConstructor(type);
            return constructor.newInstance(parameter);
        }
        catch (IncompatibleClassException ice) {
            throw ice;
        }
        catch (Throwable t) {
            throw new DynamicClassLoadingException("Failed to instantiate type " + className, t);
        }
    }

    public static String substVars(String val, PropertyContainer pc1) {
        return OptionHelper.substVars(val, pc1, null);
    }

    public static String substVars(String input2, PropertyContainer pc0, PropertyContainer pc1) {
        try {
            return NodeToStringTransformer.substituteVariable(input2, pc0, pc1);
        }
        catch (ScanException e) {
            throw new IllegalArgumentException("Failed to parse input [" + input2 + "]", e);
        }
    }

    public static String propertyLookup(String key2, PropertyContainer pc1, PropertyContainer pc2) {
        String value2 = null;
        value2 = pc1.getProperty(key2);
        if (value2 == null && pc2 != null) {
            value2 = pc2.getProperty(key2);
        }
        if (value2 == null) {
            value2 = OptionHelper.getSystemProperty(key2, null);
        }
        if (value2 == null) {
            value2 = OptionHelper.getEnv(key2);
        }
        return value2;
    }

    public static String getSystemProperty(String key2, String def) {
        try {
            return System.getProperty(key2, def);
        }
        catch (SecurityException e) {
            return def;
        }
    }

    public static String getEnv(String key2) {
        try {
            return System.getenv(key2);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static String getSystemProperty(String key2) {
        try {
            return System.getProperty(key2);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static void setSystemProperties(ContextAware contextAware, Properties props) {
        for (Object o2 : props.keySet()) {
            String key2 = (String)o2;
            String value2 = props.getProperty(key2);
            OptionHelper.setSystemProperty(contextAware, key2, value2);
        }
    }

    public static void setSystemProperty(ContextAware contextAware, String key2, String value2) {
        try {
            System.setProperty(key2, value2);
        }
        catch (SecurityException e) {
            contextAware.addError("Failed to set system property [" + key2 + "]", e);
        }
    }

    public static Properties getSystemProperties() {
        try {
            return System.getProperties();
        }
        catch (SecurityException e) {
            return new Properties();
        }
    }

    public static String[] extractDefaultReplacement(String key2) {
        String[] result2 = new String[2];
        if (key2 == null) {
            return result2;
        }
        result2[0] = key2;
        int d = key2.indexOf(DELIM_DEFAULT);
        if (d != -1) {
            result2[0] = key2.substring(0, d);
            result2[1] = key2.substring(d + 2);
        }
        return result2;
    }

    public static boolean toBoolean(String value2, boolean dEfault) {
        if (value2 == null) {
            return dEfault;
        }
        String trimmedVal = value2.trim();
        if ("true".equalsIgnoreCase(trimmedVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmedVal)) {
            return false;
        }
        return dEfault;
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }
}

