/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.filter.FilteringParserDelegate;
import com.fasterxml.jackson.core.filter.JsonPointerBasedFilter;
import com.fasterxml.jackson.core.filter.TokenFilter;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.deser.DataFormatReaders;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectReader
extends ObjectCodec
implements Versioned,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final JavaType JSON_NODE_TYPE = SimpleType.constructUnsafe(JsonNode.class);
    protected final DeserializationConfig _config;
    protected final DefaultDeserializationContext _context;
    protected final JsonFactory _parserFactory;
    protected final boolean _unwrapRoot;
    private final TokenFilter _filter;
    protected final JavaType _valueType;
    protected final JsonDeserializer<Object> _rootDeserializer;
    protected final Object _valueToUpdate;
    protected final FormatSchema _schema;
    protected final InjectableValues _injectableValues;
    protected final DataFormatReaders _dataFormatReaders;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers;

    protected ObjectReader(ObjectMapper mapper, DeserializationConfig config) {
        this(mapper, config, null, null, null, null);
    }

    protected ObjectReader(ObjectMapper mapper, DeserializationConfig config, JavaType valueType, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues) {
        this._config = config;
        this._context = mapper._deserializationContext;
        this._rootDeserializers = mapper._rootDeserializers;
        this._parserFactory = mapper._jsonFactory;
        this._valueType = valueType;
        this._valueToUpdate = valueToUpdate;
        if (valueToUpdate != null && valueType.isArrayType()) {
            throw new IllegalArgumentException("Can not update an array value");
        }
        this._schema = schema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = config.useRootWrapping();
        this._rootDeserializer = this._prefetchRootDeserializer(valueType);
        this._dataFormatReaders = null;
        this._filter = null;
    }

    protected ObjectReader(ObjectReader base2, DeserializationConfig config, JavaType valueType, JsonDeserializer<Object> rootDeser, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues, DataFormatReaders dataFormatReaders) {
        this._config = config;
        this._context = base2._context;
        this._rootDeserializers = base2._rootDeserializers;
        this._parserFactory = base2._parserFactory;
        this._valueType = valueType;
        this._rootDeserializer = rootDeser;
        this._valueToUpdate = valueToUpdate;
        if (valueToUpdate != null && valueType.isArrayType()) {
            throw new IllegalArgumentException("Can not update an array value");
        }
        this._schema = schema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = config.useRootWrapping();
        this._dataFormatReaders = dataFormatReaders;
        this._filter = base2._filter;
    }

    protected ObjectReader(ObjectReader base2, DeserializationConfig config) {
        this._config = config;
        this._context = base2._context;
        this._rootDeserializers = base2._rootDeserializers;
        this._parserFactory = base2._parserFactory;
        this._valueType = base2._valueType;
        this._rootDeserializer = base2._rootDeserializer;
        this._valueToUpdate = base2._valueToUpdate;
        this._schema = base2._schema;
        this._injectableValues = base2._injectableValues;
        this._unwrapRoot = config.useRootWrapping();
        this._dataFormatReaders = base2._dataFormatReaders;
        this._filter = base2._filter;
    }

    protected ObjectReader(ObjectReader base2, JsonFactory f) {
        this._config = base2._config.with(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, f.requiresPropertyOrdering());
        this._context = base2._context;
        this._rootDeserializers = base2._rootDeserializers;
        this._parserFactory = f;
        this._valueType = base2._valueType;
        this._rootDeserializer = base2._rootDeserializer;
        this._valueToUpdate = base2._valueToUpdate;
        this._schema = base2._schema;
        this._injectableValues = base2._injectableValues;
        this._unwrapRoot = base2._unwrapRoot;
        this._dataFormatReaders = base2._dataFormatReaders;
        this._filter = base2._filter;
    }

    protected ObjectReader(ObjectReader base2, TokenFilter filter2) {
        this._config = base2._config;
        this._context = base2._context;
        this._rootDeserializers = base2._rootDeserializers;
        this._parserFactory = base2._parserFactory;
        this._valueType = base2._valueType;
        this._rootDeserializer = base2._rootDeserializer;
        this._valueToUpdate = base2._valueToUpdate;
        this._schema = base2._schema;
        this._injectableValues = base2._injectableValues;
        this._unwrapRoot = base2._unwrapRoot;
        this._dataFormatReaders = base2._dataFormatReaders;
        this._filter = filter2;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    protected ObjectReader _new(ObjectReader base2, JsonFactory f) {
        return new ObjectReader(base2, f);
    }

    protected ObjectReader _new(ObjectReader base2, DeserializationConfig config) {
        return new ObjectReader(base2, config);
    }

    protected ObjectReader _new(ObjectReader base2, DeserializationConfig config, JavaType valueType, JsonDeserializer<Object> rootDeser, Object valueToUpdate, FormatSchema schema, InjectableValues injectableValues, DataFormatReaders dataFormatReaders) {
        return new ObjectReader(base2, config, valueType, rootDeser, valueToUpdate, schema, injectableValues, dataFormatReaders);
    }

    protected <T> MappingIterator<T> _newIterator(JsonParser p2, DeserializationContext ctxt, JsonDeserializer<?> deser, boolean parserManaged) {
        return new MappingIterator(this._valueType, p2, ctxt, deser, parserManaged, this._valueToUpdate);
    }

    protected JsonToken _initForReading(DeserializationContext ctxt, JsonParser p2) throws IOException {
        if (this._schema != null) {
            p2.setSchema(this._schema);
        }
        this._config.initialize(p2);
        JsonToken t = p2.getCurrentToken();
        if (t == null && (t = p2.nextToken()) == null) {
            ctxt.reportMissingContent(null, new Object[0]);
        }
        return t;
    }

    protected void _initForMultiRead(DeserializationContext ctxt, JsonParser p2) throws IOException {
        if (this._schema != null) {
            p2.setSchema(this._schema);
        }
        this._config.initialize(p2);
    }

    public ObjectReader with(DeserializationFeature feature2) {
        return this._with(this._config.with(feature2));
    }

    public ObjectReader with(DeserializationFeature first, DeserializationFeature ... other) {
        return this._with(this._config.with(first, other));
    }

    public ObjectReader withFeatures(DeserializationFeature ... features) {
        return this._with(this._config.withFeatures(features));
    }

    public ObjectReader without(DeserializationFeature feature2) {
        return this._with(this._config.without(feature2));
    }

    public ObjectReader without(DeserializationFeature first, DeserializationFeature ... other) {
        return this._with(this._config.without(first, other));
    }

    public ObjectReader withoutFeatures(DeserializationFeature ... features) {
        return this._with(this._config.withoutFeatures(features));
    }

    public ObjectReader with(JsonParser.Feature feature2) {
        return this._with(this._config.with(feature2));
    }

    public ObjectReader withFeatures(JsonParser.Feature ... features) {
        return this._with(this._config.withFeatures(features));
    }

    public ObjectReader without(JsonParser.Feature feature2) {
        return this._with(this._config.without(feature2));
    }

    public ObjectReader withoutFeatures(JsonParser.Feature ... features) {
        return this._with(this._config.withoutFeatures(features));
    }

    public ObjectReader with(FormatFeature feature2) {
        return this._with(this._config.with(feature2));
    }

    public ObjectReader withFeatures(FormatFeature ... features) {
        return this._with(this._config.withFeatures(features));
    }

    public ObjectReader without(FormatFeature feature2) {
        return this._with(this._config.without(feature2));
    }

    public ObjectReader withoutFeatures(FormatFeature ... features) {
        return this._with(this._config.withoutFeatures(features));
    }

    public ObjectReader at(String value2) {
        return new ObjectReader(this, new JsonPointerBasedFilter(value2));
    }

    public ObjectReader at(JsonPointer pointer) {
        return new ObjectReader(this, new JsonPointerBasedFilter(pointer));
    }

    public ObjectReader with(DeserializationConfig config) {
        return this._with(config);
    }

    public ObjectReader with(InjectableValues injectableValues) {
        if (this._injectableValues == injectableValues) {
            return this;
        }
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, this._schema, injectableValues, this._dataFormatReaders);
    }

    public ObjectReader with(JsonNodeFactory f) {
        return this._with(this._config.with(f));
    }

    public ObjectReader with(JsonFactory f) {
        if (f == this._parserFactory) {
            return this;
        }
        ObjectReader r = this._new(this, f);
        if (f.getCodec() == null) {
            f.setCodec(r);
        }
        return r;
    }

    public ObjectReader withRootName(String rootName) {
        return this._with((DeserializationConfig)this._config.withRootName(rootName));
    }

    public ObjectReader withRootName(PropertyName rootName) {
        return this._with(this._config.withRootName(rootName));
    }

    public ObjectReader withoutRootName() {
        return this._with(this._config.withRootName(PropertyName.NO_NAME));
    }

    public ObjectReader with(FormatSchema schema) {
        if (this._schema == schema) {
            return this;
        }
        this._verifySchemaType(schema);
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, schema, this._injectableValues, this._dataFormatReaders);
    }

    public ObjectReader forType(JavaType valueType) {
        if (valueType != null && valueType.equals(this._valueType)) {
            return this;
        }
        JsonDeserializer<Object> rootDeser = this._prefetchRootDeserializer(valueType);
        DataFormatReaders det = this._dataFormatReaders;
        if (det != null) {
            det = det.withType(valueType);
        }
        return this._new(this, this._config, valueType, rootDeser, this._valueToUpdate, this._schema, this._injectableValues, det);
    }

    public ObjectReader forType(Class<?> valueType) {
        return this.forType(this._config.constructType(valueType));
    }

    public ObjectReader forType(TypeReference<?> valueTypeRef) {
        return this.forType(this._config.getTypeFactory().constructType(valueTypeRef.getType()));
    }

    @Deprecated
    public ObjectReader withType(JavaType valueType) {
        return this.forType(valueType);
    }

    @Deprecated
    public ObjectReader withType(Class<?> valueType) {
        return this.forType(this._config.constructType(valueType));
    }

    @Deprecated
    public ObjectReader withType(Type valueType) {
        return this.forType(this._config.getTypeFactory().constructType(valueType));
    }

    @Deprecated
    public ObjectReader withType(TypeReference<?> valueTypeRef) {
        return this.forType(this._config.getTypeFactory().constructType(valueTypeRef.getType()));
    }

    public ObjectReader withValueToUpdate(Object value2) {
        if (value2 == this._valueToUpdate) {
            return this;
        }
        if (value2 == null) {
            return this._new(this, this._config, this._valueType, this._rootDeserializer, null, this._schema, this._injectableValues, this._dataFormatReaders);
        }
        JavaType t = this._valueType == null ? this._config.constructType(value2.getClass()) : this._valueType;
        return this._new(this, this._config, t, this._rootDeserializer, value2, this._schema, this._injectableValues, this._dataFormatReaders);
    }

    public ObjectReader withView(Class<?> activeView) {
        return this._with((DeserializationConfig)this._config.withView((Class)activeView));
    }

    public ObjectReader with(Locale l) {
        return this._with(this._config.with(l));
    }

    public ObjectReader with(TimeZone tz) {
        return this._with(this._config.with(tz));
    }

    public ObjectReader withHandler(DeserializationProblemHandler h) {
        return this._with(this._config.withHandler(h));
    }

    public ObjectReader with(Base64Variant defaultBase64) {
        return this._with(this._config.with(defaultBase64));
    }

    public ObjectReader withFormatDetection(ObjectReader ... readers) {
        return this.withFormatDetection(new DataFormatReaders(readers));
    }

    public ObjectReader withFormatDetection(DataFormatReaders readers) {
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, this._schema, this._injectableValues, readers);
    }

    public ObjectReader with(ContextAttributes attrs) {
        return this._with(this._config.with(attrs));
    }

    public ObjectReader withAttributes(Map<?, ?> attrs) {
        return this._with((DeserializationConfig)this._config.withAttributes(attrs));
    }

    public ObjectReader withAttribute(Object key2, Object value2) {
        return this._with((DeserializationConfig)this._config.withAttribute(key2, value2));
    }

    public ObjectReader withoutAttribute(Object key2) {
        return this._with((DeserializationConfig)this._config.withoutAttribute(key2));
    }

    protected ObjectReader _with(DeserializationConfig newConfig) {
        if (newConfig == this._config) {
            return this;
        }
        ObjectReader r = this._new(this, newConfig);
        if (this._dataFormatReaders != null) {
            r = r.withFormatDetection(this._dataFormatReaders.with(newConfig));
        }
        return r;
    }

    public boolean isEnabled(DeserializationFeature f) {
        return this._config.isEnabled(f);
    }

    public boolean isEnabled(MapperFeature f) {
        return this._config.isEnabled(f);
    }

    public boolean isEnabled(JsonParser.Feature f) {
        return this._parserFactory.isEnabled(f);
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    @Override
    public JsonFactory getFactory() {
        return this._parserFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public ContextAttributes getAttributes() {
        return this._config.getAttributes();
    }

    public InjectableValues getInjectableValues() {
        return this._injectableValues;
    }

    public <T> T readValue(JsonParser p2) throws IOException {
        return (T)this._bind(p2, this._valueToUpdate);
    }

    @Override
    public <T> T readValue(JsonParser p2, Class<T> valueType) throws IOException {
        return this.forType(valueType).readValue(p2);
    }

    @Override
    public <T> T readValue(JsonParser p2, TypeReference<?> valueTypeRef) throws IOException {
        return this.forType(valueTypeRef).readValue(p2);
    }

    @Override
    public <T> T readValue(JsonParser p2, ResolvedType valueType) throws IOException, JsonProcessingException {
        return this.forType((JavaType)valueType).readValue(p2);
    }

    public <T> T readValue(JsonParser p2, JavaType valueType) throws IOException {
        return this.forType(valueType).readValue(p2);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser p2, Class<T> valueType) throws IOException {
        return this.forType(valueType).readValues(p2);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser p2, TypeReference<?> valueTypeRef) throws IOException {
        return this.forType(valueTypeRef).readValues(p2);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser p2, ResolvedType valueType) throws IOException {
        return this.readValues(p2, (JavaType)valueType);
    }

    public <T> Iterator<T> readValues(JsonParser p2, JavaType valueType) throws IOException {
        return this.forType(valueType).readValues(p2);
    }

    @Override
    public JsonNode createArrayNode() {
        return this._config.getNodeFactory().arrayNode();
    }

    @Override
    public JsonNode createObjectNode() {
        return this._config.getNodeFactory().objectNode();
    }

    @Override
    public JsonParser treeAsTokens(TreeNode n) {
        return new TreeTraversingParser((JsonNode)n, this);
    }

    @Override
    public <T extends TreeNode> T readTree(JsonParser p2) throws IOException {
        return (T)this._bindAsTree(p2);
    }

    @Override
    public void writeTree(JsonGenerator jgen, TreeNode rootNode) {
        throw new UnsupportedOperationException();
    }

    public <T> T readValue(InputStream src) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(this._dataFormatReaders.findFormat(src), false);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(src), false));
    }

    public <T> T readValue(Reader src) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(src);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(src), false));
    }

    public <T> T readValue(String src) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(src);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(src), false));
    }

    public <T> T readValue(byte[] src) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(src, 0, src.length);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(src), false));
    }

    public <T> T readValue(byte[] src, int offset, int length2) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(src, offset, length2);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(src, offset, length2), false));
    }

    public <T> T readValue(File src) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(this._dataFormatReaders.findFormat(this._inputStream(src)), true);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(src), false));
    }

    public <T> T readValue(URL src) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(this._dataFormatReaders.findFormat(this._inputStream(src)), true);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(src), false));
    }

    public <T> T readValue(JsonNode src) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(src);
        }
        return (T)this._bindAndClose(this._considerFilter(this.treeAsTokens(src), false));
    }

    public <T> T readValue(DataInput src) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(src);
        }
        return (T)this._bindAndClose(this._considerFilter(this._parserFactory.createParser(src), false));
    }

    public JsonNode readTree(InputStream in) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndCloseAsTree(in);
        }
        return this._bindAndCloseAsTree(this._considerFilter(this._parserFactory.createParser(in), false));
    }

    public JsonNode readTree(Reader r) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(r);
        }
        return this._bindAndCloseAsTree(this._considerFilter(this._parserFactory.createParser(r), false));
    }

    public JsonNode readTree(String json) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(json);
        }
        return this._bindAndCloseAsTree(this._considerFilter(this._parserFactory.createParser(json), false));
    }

    public JsonNode readTree(DataInput src) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(src);
        }
        return this._bindAndCloseAsTree(this._considerFilter(this._parserFactory.createParser(src), false));
    }

    public <T> MappingIterator<T> readValues(JsonParser p2) throws IOException, JsonProcessingException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p2);
        return this._newIterator(p2, ctxt, this._findRootDeserializer(ctxt), false);
    }

    public <T> MappingIterator<T> readValues(InputStream src) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(src), false);
        }
        return this._bindAndReadValues(this._considerFilter(this._parserFactory.createParser(src), true));
    }

    public <T> MappingIterator<T> readValues(Reader src) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(src);
        }
        JsonParser p2 = this._considerFilter(this._parserFactory.createParser(src), true);
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p2);
        this._initForMultiRead(ctxt, p2);
        p2.nextToken();
        return this._newIterator(p2, ctxt, this._findRootDeserializer(ctxt), true);
    }

    public <T> MappingIterator<T> readValues(String json) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(json);
        }
        JsonParser p2 = this._considerFilter(this._parserFactory.createParser(json), true);
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p2);
        this._initForMultiRead(ctxt, p2);
        p2.nextToken();
        return this._newIterator(p2, ctxt, this._findRootDeserializer(ctxt), true);
    }

    public <T> MappingIterator<T> readValues(byte[] src, int offset, int length2) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(src, offset, length2), false);
        }
        return this._bindAndReadValues(this._considerFilter(this._parserFactory.createParser(src, offset, length2), true));
    }

    public final <T> MappingIterator<T> readValues(byte[] src) throws IOException, JsonProcessingException {
        return this.readValues(src, 0, src.length);
    }

    public <T> MappingIterator<T> readValues(File src) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(this._inputStream(src)), false);
        }
        return this._bindAndReadValues(this._considerFilter(this._parserFactory.createParser(src), true));
    }

    public <T> MappingIterator<T> readValues(URL src) throws IOException, JsonProcessingException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(this._inputStream(src)), true);
        }
        return this._bindAndReadValues(this._considerFilter(this._parserFactory.createParser(src), true));
    }

    public <T> MappingIterator<T> readValues(DataInput src) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(src);
        }
        return this._bindAndReadValues(this._considerFilter(this._parserFactory.createParser(src), true));
    }

    @Override
    public <T> T treeToValue(TreeNode n, Class<T> valueType) throws JsonProcessingException {
        try {
            return this.readValue(this.treeAsTokens(n), valueType);
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public void writeValue(JsonGenerator gen, Object value2) throws IOException, JsonProcessingException {
        throw new UnsupportedOperationException("Not implemented for ObjectReader");
    }

    protected Object _bind(JsonParser p2, Object valueToUpdate) throws IOException {
        Object result2;
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p2);
        JsonToken t = this._initForReading(ctxt, p2);
        if (t == JsonToken.VALUE_NULL) {
            result2 = valueToUpdate == null ? this._findRootDeserializer(ctxt).getNullValue(ctxt) : valueToUpdate;
        } else if (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT) {
            result2 = valueToUpdate;
        } else {
            JsonDeserializer<Object> deser = this._findRootDeserializer(ctxt);
            if (this._unwrapRoot) {
                result2 = this._unwrapAndDeserialize(p2, ctxt, this._valueType, deser);
            } else if (valueToUpdate == null) {
                result2 = deser.deserialize(p2, ctxt);
            } else {
                deser.deserialize(p2, ctxt, valueToUpdate);
                result2 = valueToUpdate;
            }
        }
        p2.clearCurrentToken();
        return result2;
    }

    protected JsonParser _considerFilter(JsonParser p2, boolean multiValue) {
        return this._filter == null || FilteringParserDelegate.class.isInstance(p2) ? p2 : new FilteringParserDelegate(p2, this._filter, false, multiValue);
    }

    protected Object _bindAndClose(JsonParser p0) throws IOException {
        try (JsonParser p2 = p0;){
            Object result2;
            DefaultDeserializationContext ctxt = this.createDeserializationContext(p2);
            JsonToken t = this._initForReading(ctxt, p2);
            if (t == JsonToken.VALUE_NULL) {
                result2 = this._valueToUpdate == null ? this._findRootDeserializer(ctxt).getNullValue(ctxt) : this._valueToUpdate;
            } else if (t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT) {
                result2 = this._valueToUpdate;
            } else {
                JsonDeserializer<Object> deser = this._findRootDeserializer(ctxt);
                if (this._unwrapRoot) {
                    result2 = this._unwrapAndDeserialize(p2, ctxt, this._valueType, deser);
                } else if (this._valueToUpdate == null) {
                    result2 = deser.deserialize(p2, ctxt);
                } else {
                    deser.deserialize(p2, ctxt, this._valueToUpdate);
                    result2 = this._valueToUpdate;
                }
            }
            Object object = result2;
            return object;
        }
    }

    protected JsonNode _bindAndCloseAsTree(JsonParser p0) throws IOException {
        try (JsonParser p2 = p0;){
            JsonNode jsonNode = this._bindAsTree(p2);
            return jsonNode;
        }
    }

    protected JsonNode _bindAsTree(JsonParser p2) throws IOException {
        JsonNode result2;
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p2);
        JsonToken t = this._initForReading(ctxt, p2);
        if (t == JsonToken.VALUE_NULL || t == JsonToken.END_ARRAY || t == JsonToken.END_OBJECT) {
            result2 = NullNode.instance;
        } else {
            JsonDeserializer<Object> deser = this._findTreeDeserializer(ctxt);
            result2 = this._unwrapRoot ? (JsonNode)this._unwrapAndDeserialize(p2, ctxt, JSON_NODE_TYPE, deser) : (JsonNode)deser.deserialize(p2, ctxt);
        }
        p2.clearCurrentToken();
        return result2;
    }

    protected <T> MappingIterator<T> _bindAndReadValues(JsonParser p2) throws IOException {
        DefaultDeserializationContext ctxt = this.createDeserializationContext(p2);
        this._initForMultiRead(ctxt, p2);
        p2.nextToken();
        return this._newIterator(p2, ctxt, this._findRootDeserializer(ctxt), true);
    }

    protected Object _unwrapAndDeserialize(JsonParser p2, DeserializationContext ctxt, JavaType rootType, JsonDeserializer<Object> deser) throws IOException {
        Object result2;
        String actualName;
        PropertyName expRootName = this._config.findRootName(rootType);
        String expSimpleName = expRootName.getSimpleName();
        if (p2.getCurrentToken() != JsonToken.START_OBJECT) {
            ctxt.reportWrongTokenException(p2, JsonToken.START_OBJECT, "Current token not START_OBJECT (needed to unwrap root name '%s'), but %s", new Object[]{expSimpleName, p2.getCurrentToken()});
        }
        if (p2.nextToken() != JsonToken.FIELD_NAME) {
            ctxt.reportWrongTokenException(p2, JsonToken.FIELD_NAME, "Current token not FIELD_NAME (to contain expected root name '%s'), but %s", new Object[]{expSimpleName, p2.getCurrentToken()});
        }
        if (!expSimpleName.equals(actualName = p2.getCurrentName())) {
            ctxt.reportMappingException("Root name '%s' does not match expected ('%s') for type %s", actualName, expSimpleName, rootType);
        }
        p2.nextToken();
        if (this._valueToUpdate == null) {
            result2 = deser.deserialize(p2, ctxt);
        } else {
            deser.deserialize(p2, ctxt, this._valueToUpdate);
            result2 = this._valueToUpdate;
        }
        if (p2.nextToken() != JsonToken.END_OBJECT) {
            ctxt.reportWrongTokenException(p2, JsonToken.END_OBJECT, "Current token not END_OBJECT (to match wrapper object with root name '%s'), but %s", new Object[]{expSimpleName, p2.getCurrentToken()});
        }
        return result2;
    }

    protected Object _detectBindAndClose(byte[] src, int offset, int length2) throws IOException {
        DataFormatReaders.Match match = this._dataFormatReaders.findFormat(src, offset, length2);
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser p2 = match.createParserWithMatch();
        return match.getReader()._bindAndClose(p2);
    }

    protected Object _detectBindAndClose(DataFormatReaders.Match match, boolean forceClosing) throws IOException {
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser p2 = match.createParserWithMatch();
        if (forceClosing) {
            p2.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        }
        return match.getReader()._bindAndClose(p2);
    }

    protected <T> MappingIterator<T> _detectBindAndReadValues(DataFormatReaders.Match match, boolean forceClosing) throws IOException, JsonProcessingException {
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser p2 = match.createParserWithMatch();
        if (forceClosing) {
            p2.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        }
        return match.getReader()._bindAndReadValues(p2);
    }

    protected JsonNode _detectBindAndCloseAsTree(InputStream in) throws IOException {
        DataFormatReaders.Match match = this._dataFormatReaders.findFormat(in);
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser p2 = match.createParserWithMatch();
        p2.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        return match.getReader()._bindAndCloseAsTree(p2);
    }

    protected void _reportUnkownFormat(DataFormatReaders detector, DataFormatReaders.Match match) throws JsonProcessingException {
        throw new JsonParseException(null, "Can not detect format from input, does not look like any of detectable formats " + detector.toString());
    }

    protected void _verifySchemaType(FormatSchema schema) {
        if (schema != null && !this._parserFactory.canUseSchema(schema)) {
            throw new IllegalArgumentException("Can not use FormatSchema of type " + schema.getClass().getName() + " for format " + this._parserFactory.getFormatName());
        }
    }

    protected DefaultDeserializationContext createDeserializationContext(JsonParser p2) {
        return this._context.createInstance(this._config, p2, this._injectableValues);
    }

    protected void _reportUndetectableSource(Object src) throws JsonProcessingException {
        throw new JsonParseException(null, "Can not use source of type " + src.getClass().getName() + " with format auto-detection: must be byte- not char-based");
    }

    protected InputStream _inputStream(URL src) throws IOException {
        return src.openStream();
    }

    protected InputStream _inputStream(File f) throws IOException {
        return new FileInputStream(f);
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext ctxt) throws JsonMappingException {
        JsonDeserializer<Object> deser;
        if (this._rootDeserializer != null) {
            return this._rootDeserializer;
        }
        JavaType t = this._valueType;
        if (t == null) {
            ctxt.reportMappingException("No value type configured for ObjectReader", new Object[0]);
        }
        if ((deser = this._rootDeserializers.get(t)) != null) {
            return deser;
        }
        deser = ctxt.findRootValueDeserializer(t);
        if (deser == null) {
            ctxt.reportMappingException("Can not find a deserializer for type %s", t);
        }
        this._rootDeserializers.put(t, deser);
        return deser;
    }

    protected JsonDeserializer<Object> _findTreeDeserializer(DeserializationContext ctxt) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._rootDeserializers.get(JSON_NODE_TYPE);
        if (deser == null) {
            deser = ctxt.findRootValueDeserializer(JSON_NODE_TYPE);
            if (deser == null) {
                ctxt.reportMappingException("Can not find a deserializer for type %s", JSON_NODE_TYPE);
            }
            this._rootDeserializers.put(JSON_NODE_TYPE, deser);
        }
        return deser;
    }

    protected JsonDeserializer<Object> _prefetchRootDeserializer(JavaType valueType) {
        if (valueType == null || !this._config.isEnabled(DeserializationFeature.EAGER_DESERIALIZER_FETCH)) {
            return null;
        }
        JsonDeserializer<Object> deser = this._rootDeserializers.get(valueType);
        if (deser == null) {
            try {
                DefaultDeserializationContext ctxt = this.createDeserializationContext(null);
                deser = ctxt.findRootValueDeserializer(valueType);
                if (deser != null) {
                    this._rootDeserializers.put(valueType, deser);
                }
                return deser;
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return deser;
    }
}

