/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.BeanAsArrayBuilderDeserializer;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ExternalTypeHandler;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class BuilderBasedDeserializer
extends BeanDeserializerBase {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedMethod _buildMethod;

    public BuilderBasedDeserializer(BeanDeserializerBuilder builder, BeanDescription beanDesc, BeanPropertyMap properties, Map<String, SettableBeanProperty> backRefs, Set<String> ignorableProps, boolean ignoreAllUnknown, boolean hasViews) {
        super(builder, beanDesc, properties, backRefs, ignorableProps, ignoreAllUnknown, hasViews);
        this._buildMethod = builder.getBuildMethod();
        if (this._objectIdReader != null) {
            throw new IllegalArgumentException("Can not use Object Id with Builder-based deserialization (type " + beanDesc.getType() + ")");
        }
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer src) {
        this(src, src._ignoreAllUnknown);
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer src, boolean ignoreAllUnknown) {
        super((BeanDeserializerBase)src, ignoreAllUnknown);
        this._buildMethod = src._buildMethod;
    }

    protected BuilderBasedDeserializer(BuilderBasedDeserializer src, NameTransformer unwrapper) {
        super((BeanDeserializerBase)src, unwrapper);
        this._buildMethod = src._buildMethod;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, ObjectIdReader oir) {
        super((BeanDeserializerBase)src, oir);
        this._buildMethod = src._buildMethod;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, Set<String> ignorableProps) {
        super((BeanDeserializerBase)src, ignorableProps);
        this._buildMethod = src._buildMethod;
    }

    public BuilderBasedDeserializer(BuilderBasedDeserializer src, BeanPropertyMap props) {
        super((BeanDeserializerBase)src, props);
        this._buildMethod = src._buildMethod;
    }

    @Override
    public JsonDeserializer<Object> unwrappingDeserializer(NameTransformer unwrapper) {
        return new BuilderBasedDeserializer(this, unwrapper);
    }

    @Override
    public BeanDeserializerBase withObjectIdReader(ObjectIdReader oir) {
        return new BuilderBasedDeserializer(this, oir);
    }

    @Override
    public BeanDeserializerBase withIgnorableProperties(Set<String> ignorableProps) {
        return new BuilderBasedDeserializer(this, ignorableProps);
    }

    @Override
    public BeanDeserializerBase withBeanProperties(BeanPropertyMap props) {
        return new BuilderBasedDeserializer(this, props);
    }

    @Override
    protected BeanDeserializerBase asArrayDeserializer() {
        SettableBeanProperty[] props = this._beanProperties.getPropertiesInInsertionOrder();
        return new BeanAsArrayBuilderDeserializer(this, props, this._buildMethod);
    }

    protected final Object finishBuild(DeserializationContext ctxt, Object builder) throws IOException {
        if (null == this._buildMethod) {
            return builder;
        }
        try {
            return this._buildMethod.getMember().invoke(builder, new Object[0]);
        }
        catch (Exception e) {
            return this.wrapInstantiationProblem(e, ctxt);
        }
    }

    @Override
    public final Object deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p2.nextToken();
            if (this._vanillaProcessing) {
                return this.finishBuild(ctxt, this.vanillaDeserialize(p2, ctxt, t));
            }
            Object builder = this.deserializeFromObject(p2, ctxt);
            return this.finishBuild(ctxt, builder);
        }
        if (t != null) {
            switch (t) {
                case VALUE_STRING: {
                    return this.finishBuild(ctxt, this.deserializeFromString(p2, ctxt));
                }
                case VALUE_NUMBER_INT: {
                    return this.finishBuild(ctxt, this.deserializeFromNumber(p2, ctxt));
                }
                case VALUE_NUMBER_FLOAT: {
                    return this.finishBuild(ctxt, this.deserializeFromDouble(p2, ctxt));
                }
                case VALUE_EMBEDDED_OBJECT: {
                    return p2.getEmbeddedObject();
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    return this.finishBuild(ctxt, this.deserializeFromBoolean(p2, ctxt));
                }
                case START_ARRAY: {
                    return this.finishBuild(ctxt, this.deserializeFromArray(p2, ctxt));
                }
                case FIELD_NAME: 
                case END_OBJECT: {
                    return this.finishBuild(ctxt, this.deserializeFromObject(p2, ctxt));
                }
            }
        }
        return ctxt.handleUnexpectedToken(this.handledType(), p2);
    }

    @Override
    public Object deserialize(JsonParser p2, DeserializationContext ctxt, Object builder) throws IOException {
        return this.finishBuild(ctxt, this._deserialize(p2, ctxt, builder));
    }

    protected final Object _deserialize(JsonParser p2, DeserializationContext ctxt, Object builder) throws IOException, JsonProcessingException {
        Class<?> view;
        if (this._injectables != null) {
            this.injectValues(ctxt, builder);
        }
        if (this._unwrappedPropertyHandler != null) {
            return this.deserializeWithUnwrapped(p2, ctxt, builder);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(p2, ctxt, builder);
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p2, ctxt, builder, view);
        }
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p2.nextToken();
        }
        while (t == JsonToken.FIELD_NAME) {
            String propName = p2.getCurrentName();
            p2.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                try {
                    builder = prop.deserializeSetAndReturn(p2, ctxt, builder);
                }
                catch (Exception e) {
                    this.wrapAndThrow((Throwable)e, builder, propName, ctxt);
                }
            } else {
                this.handleUnknownVanilla(p2, ctxt, this.handledType(), propName);
            }
            t = p2.nextToken();
        }
        return builder;
    }

    private final Object vanillaDeserialize(JsonParser p2, DeserializationContext ctxt, JsonToken t) throws IOException, JsonProcessingException {
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        while (p2.getCurrentToken() != JsonToken.END_OBJECT) {
            String propName = p2.getCurrentName();
            p2.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                try {
                    bean = prop.deserializeSetAndReturn(p2, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow((Throwable)e, bean, propName, ctxt);
                }
            } else {
                this.handleUnknownVanilla(p2, ctxt, bean, propName);
            }
            p2.nextToken();
        }
        return bean;
    }

    @Override
    public Object deserializeFromObject(JsonParser p2, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Class<?> view;
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(p2, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(p2, ctxt);
            }
            return this.deserializeFromObjectUsingNonDefault(p2, ctxt);
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (this._needViewProcesing && (view = ctxt.getActiveView()) != null) {
            return this.deserializeWithView(p2, ctxt, bean, view);
        }
        while (p2.getCurrentToken() != JsonToken.END_OBJECT) {
            String propName = p2.getCurrentName();
            p2.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                try {
                    bean = prop.deserializeSetAndReturn(p2, ctxt, bean);
                }
                catch (Exception e) {
                    this.wrapAndThrow((Throwable)e, bean, propName, ctxt);
                }
            } else {
                this.handleUnknownVanilla(p2, ctxt, bean, propName);
            }
            p2.nextToken();
        }
        return bean;
    }

    @Override
    protected final Object _deserializeUsingPropertyBased(JsonParser p2, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object bean;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer2 = creator.startBuilding(p2, ctxt, this._objectIdReader);
        TokenBuffer unknown = null;
        JsonToken t = p2.getCurrentToken();
        while (t == JsonToken.FIELD_NAME) {
            block20: {
                String propName = p2.getCurrentName();
                p2.nextToken();
                SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
                if (creatorProp != null) {
                    if (buffer2.assignParameter(creatorProp, creatorProp.deserialize(p2, ctxt))) {
                        Object bean2;
                        p2.nextToken();
                        try {
                            bean2 = creator.build(ctxt, buffer2);
                        }
                        catch (Exception e) {
                            this.wrapAndThrow((Throwable)e, this._beanType.getRawClass(), propName, ctxt);
                            break block20;
                        }
                        if (bean2.getClass() != this._beanType.getRawClass()) {
                            return this.handlePolymorphic(p2, ctxt, bean2, unknown);
                        }
                        if (unknown != null) {
                            bean2 = this.handleUnknownProperties(ctxt, bean2, unknown);
                        }
                        return this._deserialize(p2, ctxt, bean2);
                    }
                } else if (!buffer2.readIdProperty(propName)) {
                    SettableBeanProperty prop = this._beanProperties.find(propName);
                    if (prop != null) {
                        buffer2.bufferProperty(prop, prop.deserialize(p2, ctxt));
                    } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                        this.handleIgnoredProperty(p2, ctxt, this.handledType(), propName);
                    } else if (this._anySetter != null) {
                        buffer2.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p2, ctxt));
                    } else {
                        if (unknown == null) {
                            unknown = new TokenBuffer(p2, ctxt);
                        }
                        unknown.writeFieldName(propName);
                        unknown.copyCurrentStructure(p2);
                    }
                }
            }
            t = p2.nextToken();
        }
        try {
            bean = creator.build(ctxt, buffer2);
        }
        catch (Exception e) {
            bean = this.wrapInstantiationProblem(e, ctxt);
        }
        if (unknown != null) {
            if (bean.getClass() != this._beanType.getRawClass()) {
                return this.handlePolymorphic(null, ctxt, bean, unknown);
            }
            return this.handleUnknownProperties(ctxt, bean, unknown);
        }
        return bean;
    }

    protected final Object deserializeWithView(JsonParser p2, DeserializationContext ctxt, Object bean, Class<?> activeView) throws IOException, JsonProcessingException {
        JsonToken t = p2.getCurrentToken();
        while (t == JsonToken.FIELD_NAME) {
            String propName = p2.getCurrentName();
            p2.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                if (!prop.visibleInView(activeView)) {
                    p2.skipChildren();
                } else {
                    try {
                        bean = prop.deserializeSetAndReturn(p2, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow((Throwable)e, bean, propName, ctxt);
                    }
                }
            } else {
                this.handleUnknownVanilla(p2, ctxt, bean, propName);
            }
            t = p2.nextToken();
        }
        return bean;
    }

    protected Object deserializeWithUnwrapped(JsonParser p2, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Class<?> activeView;
        if (this._delegateDeserializer != null) {
            return this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p2, ctxt));
        }
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithUnwrapped(p2, ctxt);
        }
        TokenBuffer tokens = new TokenBuffer(p2, ctxt);
        tokens.writeStartObject();
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        Class<?> clazz = activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        while (p2.getCurrentToken() != JsonToken.END_OBJECT) {
            String propName = p2.getCurrentName();
            p2.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p2.skipChildren();
                } else {
                    try {
                        bean = prop.deserializeSetAndReturn(p2, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow((Throwable)e, bean, propName, ctxt);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                this.handleIgnoredProperty(p2, ctxt, bean, propName);
            } else {
                tokens.writeFieldName(propName);
                tokens.copyCurrentStructure(p2);
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(p2, ctxt, bean, propName);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow((Throwable)e, bean, propName, ctxt);
                    }
                }
            }
            p2.nextToken();
        }
        tokens.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(p2, ctxt, bean, tokens);
        return bean;
    }

    protected Object deserializeWithUnwrapped(JsonParser p2, DeserializationContext ctxt, Object bean) throws IOException, JsonProcessingException {
        Class<?> activeView;
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = p2.nextToken();
        }
        TokenBuffer tokens = new TokenBuffer(p2, ctxt);
        tokens.writeStartObject();
        Class<?> clazz = activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        while (t == JsonToken.FIELD_NAME) {
            String propName = p2.getCurrentName();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            p2.nextToken();
            if (prop != null) {
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p2.skipChildren();
                } else {
                    try {
                        bean = prop.deserializeSetAndReturn(p2, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow((Throwable)e, bean, propName, ctxt);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                this.handleIgnoredProperty(p2, ctxt, bean, propName);
            } else {
                tokens.writeFieldName(propName);
                tokens.copyCurrentStructure(p2);
                if (this._anySetter != null) {
                    this._anySetter.deserializeAndSet(p2, ctxt, bean, propName);
                }
            }
            t = p2.nextToken();
        }
        tokens.writeEndObject();
        this._unwrappedPropertyHandler.processUnwrapped(p2, ctxt, bean, tokens);
        return bean;
    }

    protected Object deserializeUsingPropertyBasedWithUnwrapped(JsonParser p2, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Object bean;
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer2 = creator.startBuilding(p2, ctxt, this._objectIdReader);
        TokenBuffer tokens = new TokenBuffer(p2, ctxt);
        tokens.writeStartObject();
        JsonToken t = p2.getCurrentToken();
        while (t == JsonToken.FIELD_NAME) {
            String propName = p2.getCurrentName();
            p2.nextToken();
            SettableBeanProperty creatorProp = creator.findCreatorProperty(propName);
            if (creatorProp != null) {
                buffer2.assignParameter(creatorProp, creatorProp.deserialize(p2, ctxt));
            } else if (!buffer2.readIdProperty(propName)) {
                SettableBeanProperty prop = this._beanProperties.find(propName);
                if (prop != null) {
                    buffer2.bufferProperty(prop, prop.deserialize(p2, ctxt));
                } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                    this.handleIgnoredProperty(p2, ctxt, this.handledType(), propName);
                } else {
                    tokens.writeFieldName(propName);
                    tokens.copyCurrentStructure(p2);
                    if (this._anySetter != null) {
                        buffer2.bufferAnyProperty(this._anySetter, propName, this._anySetter.deserialize(p2, ctxt));
                    }
                }
            }
            t = p2.nextToken();
        }
        try {
            bean = creator.build(ctxt, buffer2);
        }
        catch (Exception e) {
            return this.wrapInstantiationProblem(e, ctxt);
        }
        return this._unwrappedPropertyHandler.processUnwrapped(p2, ctxt, bean, tokens);
    }

    protected Object deserializeWithExternalTypeId(JsonParser p2, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this._propertyBasedCreator != null) {
            return this.deserializeUsingPropertyBasedWithExternalTypeId(p2, ctxt);
        }
        return this.deserializeWithExternalTypeId(p2, ctxt, this._valueInstantiator.createUsingDefault(ctxt));
    }

    protected Object deserializeWithExternalTypeId(JsonParser p2, DeserializationContext ctxt, Object bean) throws IOException, JsonProcessingException {
        Class<?> activeView = this._needViewProcesing ? ctxt.getActiveView() : null;
        ExternalTypeHandler ext = this._externalTypeIdHandler.start();
        JsonToken t = p2.getCurrentToken();
        while (t == JsonToken.FIELD_NAME) {
            String propName = p2.getCurrentName();
            t = p2.nextToken();
            SettableBeanProperty prop = this._beanProperties.find(propName);
            if (prop != null) {
                if (t.isScalarValue()) {
                    ext.handleTypePropertyValue(p2, ctxt, propName, bean);
                }
                if (activeView != null && !prop.visibleInView(activeView)) {
                    p2.skipChildren();
                } else {
                    try {
                        bean = prop.deserializeSetAndReturn(p2, ctxt, bean);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow((Throwable)e, bean, propName, ctxt);
                    }
                }
            } else if (this._ignorableProps != null && this._ignorableProps.contains(propName)) {
                this.handleIgnoredProperty(p2, ctxt, bean, propName);
            } else if (!ext.handlePropertyValue(p2, ctxt, propName, bean)) {
                if (this._anySetter != null) {
                    try {
                        this._anySetter.deserializeAndSet(p2, ctxt, bean, propName);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow((Throwable)e, bean, propName, ctxt);
                    }
                } else {
                    this.handleUnknownProperty(p2, ctxt, bean, propName);
                }
            }
            t = p2.nextToken();
        }
        return ext.complete(p2, ctxt, bean);
    }

    protected Object deserializeUsingPropertyBasedWithExternalTypeId(JsonParser p2, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        throw new IllegalStateException("Deserialization with Builder, External type id, @JsonCreator not yet implemented");
    }
}

