/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.RawValue;
import java.io.IOException;

abstract class BaseNodeDeserializer<T extends JsonNode>
extends StdDeserializer<T> {
    public BaseNodeDeserializer(Class<T> vc) {
        super(vc);
    }

    @Override
    public Object deserializeWithType(JsonParser p2, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(p2, ctxt);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Deprecated
    protected void _reportProblem(JsonParser p2, String msg) throws JsonMappingException {
        throw JsonMappingException.from(p2, msg);
    }

    protected void _handleDuplicateField(JsonParser p2, DeserializationContext ctxt, JsonNodeFactory nodeFactory, String fieldName, ObjectNode objectNode, JsonNode oldValue, JsonNode newValue) throws JsonProcessingException {
        if (ctxt.isEnabled(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY)) {
            ctxt.reportMappingException("Duplicate field '%s' for ObjectNode: not allowed when FAIL_ON_READING_DUP_TREE_KEY enabled", fieldName);
        }
    }

    protected final ObjectNode deserializeObject(JsonParser p2, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        String key2;
        ObjectNode node = nodeFactory.objectNode();
        if (p2.isExpectedStartObjectToken()) {
            key2 = p2.nextFieldName();
        } else {
            JsonToken t = p2.getCurrentToken();
            if (t == JsonToken.END_OBJECT) {
                return node;
            }
            if (t != JsonToken.FIELD_NAME) {
                return (ObjectNode)ctxt.handleUnexpectedToken(this.handledType(), p2);
            }
            key2 = p2.getCurrentName();
        }
        while (key2 != null) {
            JsonNode value2;
            JsonToken t = p2.nextToken();
            if (t == null) {
                throw ctxt.mappingException("Unexpected end-of-input when binding data into ObjectNode");
            }
            switch (t.id()) {
                case 1: {
                    value2 = this.deserializeObject(p2, ctxt, nodeFactory);
                    break;
                }
                case 3: {
                    value2 = this.deserializeArray(p2, ctxt, nodeFactory);
                    break;
                }
                case 12: {
                    value2 = this._fromEmbedded(p2, ctxt, nodeFactory);
                    break;
                }
                case 6: {
                    value2 = nodeFactory.textNode(p2.getText());
                    break;
                }
                case 7: {
                    value2 = this._fromInt(p2, ctxt, nodeFactory);
                    break;
                }
                case 9: {
                    value2 = nodeFactory.booleanNode(true);
                    break;
                }
                case 10: {
                    value2 = nodeFactory.booleanNode(false);
                    break;
                }
                case 11: {
                    value2 = nodeFactory.nullNode();
                    break;
                }
                default: {
                    value2 = this.deserializeAny(p2, ctxt, nodeFactory);
                }
            }
            JsonNode old = node.replace(key2, value2);
            if (old != null) {
                this._handleDuplicateField(p2, ctxt, nodeFactory, key2, node, old, value2);
            }
            key2 = p2.nextFieldName();
        }
        return node;
    }

    protected final ArrayNode deserializeArray(JsonParser p2, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        ArrayNode node = nodeFactory.arrayNode();
        block11: while (true) {
            JsonToken t = p2.nextToken();
            switch (t.id()) {
                case 1: {
                    node.add(this.deserializeObject(p2, ctxt, nodeFactory));
                    continue block11;
                }
                case 3: {
                    node.add(this.deserializeArray(p2, ctxt, nodeFactory));
                    continue block11;
                }
                case 4: {
                    return node;
                }
                case 12: {
                    node.add(this._fromEmbedded(p2, ctxt, nodeFactory));
                    continue block11;
                }
                case 6: {
                    node.add(nodeFactory.textNode(p2.getText()));
                    continue block11;
                }
                case 7: {
                    node.add(this._fromInt(p2, ctxt, nodeFactory));
                    continue block11;
                }
                case 9: {
                    node.add(nodeFactory.booleanNode(true));
                    continue block11;
                }
                case 10: {
                    node.add(nodeFactory.booleanNode(false));
                    continue block11;
                }
                case 11: {
                    node.add(nodeFactory.nullNode());
                    continue block11;
                }
            }
            node.add(this.deserializeAny(p2, ctxt, nodeFactory));
        }
    }

    protected final JsonNode deserializeAny(JsonParser p2, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        switch (p2.getCurrentTokenId()) {
            case 1: 
            case 2: 
            case 5: {
                return this.deserializeObject(p2, ctxt, nodeFactory);
            }
            case 3: {
                return this.deserializeArray(p2, ctxt, nodeFactory);
            }
            case 12: {
                return this._fromEmbedded(p2, ctxt, nodeFactory);
            }
            case 6: {
                return nodeFactory.textNode(p2.getText());
            }
            case 7: {
                return this._fromInt(p2, ctxt, nodeFactory);
            }
            case 8: {
                return this._fromFloat(p2, ctxt, nodeFactory);
            }
            case 9: {
                return nodeFactory.booleanNode(true);
            }
            case 10: {
                return nodeFactory.booleanNode(false);
            }
            case 11: {
                return nodeFactory.nullNode();
            }
        }
        return (JsonNode)ctxt.handleUnexpectedToken(this.handledType(), p2);
    }

    protected final JsonNode _fromInt(JsonParser p2, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        int feats = ctxt.getDeserializationFeatures();
        JsonParser.NumberType nt = (feats & F_MASK_INT_COERCIONS) != 0 ? (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(feats) ? JsonParser.NumberType.BIG_INTEGER : (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(feats) ? JsonParser.NumberType.LONG : p2.getNumberType())) : p2.getNumberType();
        if (nt == JsonParser.NumberType.INT) {
            return nodeFactory.numberNode(p2.getIntValue());
        }
        if (nt == JsonParser.NumberType.LONG) {
            return nodeFactory.numberNode(p2.getLongValue());
        }
        return nodeFactory.numberNode(p2.getBigIntegerValue());
    }

    protected final JsonNode _fromFloat(JsonParser p2, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        JsonParser.NumberType nt = p2.getNumberType();
        if (nt == JsonParser.NumberType.BIG_DECIMAL) {
            return nodeFactory.numberNode(p2.getDecimalValue());
        }
        if (ctxt.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            double d = p2.getDoubleValue();
            if (Double.isInfinite(d) || Double.isNaN(d)) {
                return nodeFactory.numberNode(d);
            }
            return nodeFactory.numberNode(p2.getDecimalValue());
        }
        if (nt == JsonParser.NumberType.FLOAT) {
            return nodeFactory.numberNode(p2.getFloatValue());
        }
        return nodeFactory.numberNode(p2.getDoubleValue());
    }

    protected final JsonNode _fromEmbedded(JsonParser p2, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        Object ob = p2.getEmbeddedObject();
        if (ob == null) {
            return nodeFactory.nullNode();
        }
        Class<?> type = ob.getClass();
        if (type == byte[].class) {
            return nodeFactory.binaryNode((byte[])ob);
        }
        if (ob instanceof RawValue) {
            return nodeFactory.rawValueNode((RawValue)ob);
        }
        if (ob instanceof JsonNode) {
            return (JsonNode)ob;
        }
        return nodeFactory.pojoNode(ob);
    }
}

