/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.EnumMap;

public class EnumMapDeserializer
extends ContainerDeserializerBase<EnumMap<?, ?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _mapType;
    protected final Class<?> _enumClass;
    protected KeyDeserializer _keyDeserializer;
    protected JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public EnumMapDeserializer(JavaType mapType2, KeyDeserializer keyDeserializer, JsonDeserializer<?> valueDeser, TypeDeserializer valueTypeDeser) {
        super(mapType2);
        this._mapType = mapType2;
        this._enumClass = mapType2.getKeyType().getRawClass();
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = valueDeser;
        this._valueTypeDeserializer = valueTypeDeser;
    }

    public EnumMapDeserializer withResolved(KeyDeserializer keyDeserializer, JsonDeserializer<?> valueDeserializer, TypeDeserializer valueTypeDeser) {
        if (keyDeserializer == this._keyDeserializer && valueDeserializer == this._valueDeserializer && valueTypeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return new EnumMapDeserializer(this._mapType, keyDeserializer, valueDeserializer, this._valueTypeDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property2) throws JsonMappingException {
        KeyDeserializer kd = this._keyDeserializer;
        if (kd == null) {
            kd = ctxt.findKeyDeserializer(this._mapType.getKeyType(), property2);
        }
        JsonDeserializer<Object> vd = this._valueDeserializer;
        JavaType vt = this._mapType.getContentType();
        vd = vd == null ? ctxt.findContextualValueDeserializer(vt, property2) : ctxt.handleSecondaryContextualization(vd, property2, vt);
        TypeDeserializer vtd = this._valueTypeDeserializer;
        if (vtd != null) {
            vtd = vtd.forProperty(property2);
        }
        return this.withResolved(kd, vd, vtd);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._keyDeserializer == null && this._valueTypeDeserializer == null;
    }

    @Override
    public JavaType getContentType() {
        return this._mapType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public EnumMap<?, ?> deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.getCurrentToken() != JsonToken.START_OBJECT) {
            return (EnumMap)this._deserializeFromEmpty(p2, ctxt);
        }
        EnumMap<?, ?> result2 = this.constructMap();
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        while (p2.nextToken() == JsonToken.FIELD_NAME) {
            Object value2;
            String keyName = p2.getCurrentName();
            Enum key2 = (Enum)this._keyDeserializer.deserializeKey(keyName, ctxt);
            if (key2 == null) {
                if (!ctxt.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                    return (EnumMap)ctxt.handleWeirdStringValue(this._enumClass, keyName, "value not one of declared Enum instance names for %s", this._mapType.getKeyType());
                }
                p2.nextToken();
                p2.skipChildren();
                continue;
            }
            JsonToken t = p2.nextToken();
            try {
                value2 = t == JsonToken.VALUE_NULL ? valueDes.getNullValue(ctxt) : (typeDeser == null ? valueDes.deserialize(p2, ctxt) : valueDes.deserializeWithType(p2, ctxt, typeDeser));
            }
            catch (Exception e) {
                this.wrapAndThrow(e, result2, keyName);
                return null;
            }
            result2.put(key2, value2);
        }
        return result2;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    protected EnumMap<?, ?> constructMap() {
        return new EnumMap(this._enumClass);
    }
}

