/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;

public class JsonLocationInstantiator
extends ValueInstantiator.Base {
    public JsonLocationInstantiator() {
        super(JsonLocation.class);
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return true;
    }

    @Override
    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
        JavaType intType = config.constructType(Integer.TYPE);
        JavaType longType = config.constructType(Long.TYPE);
        return new SettableBeanProperty[]{JsonLocationInstantiator.creatorProp("sourceRef", config.constructType(Object.class), 0), JsonLocationInstantiator.creatorProp("byteOffset", longType, 1), JsonLocationInstantiator.creatorProp("charOffset", longType, 2), JsonLocationInstantiator.creatorProp("lineNr", intType, 3), JsonLocationInstantiator.creatorProp("columnNr", intType, 4)};
    }

    private static CreatorProperty creatorProp(String name2, JavaType type, int index2) {
        return new CreatorProperty(PropertyName.construct(name2), type, null, null, null, null, index2, null, PropertyMetadata.STD_REQUIRED);
    }

    @Override
    public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) {
        return new JsonLocation(args[0], JsonLocationInstantiator._long(args[1]), JsonLocationInstantiator._long(args[2]), JsonLocationInstantiator._int(args[3]), JsonLocationInstantiator._int(args[4]));
    }

    private static final long _long(Object o2) {
        return o2 == null ? 0L : ((Number)o2).longValue();
    }

    private static final int _int(Object o2) {
        return o2 == null ? 0 : ((Number)o2).intValue();
    }
}

