/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JacksonStdImpl
public class MapDeserializer
extends ContainerDeserializerBase<Map<Object, Object>>
implements ContextualDeserializer,
ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _mapType;
    protected final KeyDeserializer _keyDeserializer;
    protected boolean _standardStringKey;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final boolean _hasDefaultCreator;
    protected JsonDeserializer<Object> _delegateDeserializer;
    protected PropertyBasedCreator _propertyBasedCreator;
    protected Set<String> _ignorableProperties;

    public MapDeserializer(JavaType mapType2, ValueInstantiator valueInstantiator, KeyDeserializer keyDeser, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser) {
        super(mapType2);
        this._mapType = mapType2;
        this._keyDeserializer = keyDeser;
        this._valueDeserializer = valueDeser;
        this._valueTypeDeserializer = valueTypeDeser;
        this._valueInstantiator = valueInstantiator;
        this._hasDefaultCreator = valueInstantiator.canCreateUsingDefault();
        this._delegateDeserializer = null;
        this._propertyBasedCreator = null;
        this._standardStringKey = this._isStdKeyDeser(mapType2, keyDeser);
    }

    protected MapDeserializer(MapDeserializer src) {
        super(src._mapType);
        this._mapType = src._mapType;
        this._keyDeserializer = src._keyDeserializer;
        this._valueDeserializer = src._valueDeserializer;
        this._valueTypeDeserializer = src._valueTypeDeserializer;
        this._valueInstantiator = src._valueInstantiator;
        this._propertyBasedCreator = src._propertyBasedCreator;
        this._delegateDeserializer = src._delegateDeserializer;
        this._hasDefaultCreator = src._hasDefaultCreator;
        this._ignorableProperties = src._ignorableProperties;
        this._standardStringKey = src._standardStringKey;
    }

    protected MapDeserializer(MapDeserializer src, KeyDeserializer keyDeser, JsonDeserializer<Object> valueDeser, TypeDeserializer valueTypeDeser, Set<String> ignorable) {
        super(src._mapType);
        this._mapType = src._mapType;
        this._keyDeserializer = keyDeser;
        this._valueDeserializer = valueDeser;
        this._valueTypeDeserializer = valueTypeDeser;
        this._valueInstantiator = src._valueInstantiator;
        this._propertyBasedCreator = src._propertyBasedCreator;
        this._delegateDeserializer = src._delegateDeserializer;
        this._hasDefaultCreator = src._hasDefaultCreator;
        this._ignorableProperties = ignorable;
        this._standardStringKey = this._isStdKeyDeser(this._mapType, keyDeser);
    }

    protected MapDeserializer withResolved(KeyDeserializer keyDeser, TypeDeserializer valueTypeDeser, JsonDeserializer<?> valueDeser, Set<String> ignorable) {
        if (this._keyDeserializer == keyDeser && this._valueDeserializer == valueDeser && this._valueTypeDeserializer == valueTypeDeser && this._ignorableProperties == ignorable) {
            return this;
        }
        return new MapDeserializer(this, keyDeser, valueDeser, valueTypeDeser, ignorable);
    }

    protected final boolean _isStdKeyDeser(JavaType mapType2, KeyDeserializer keyDeser) {
        if (keyDeser == null) {
            return true;
        }
        JavaType keyType = mapType2.getKeyType();
        if (keyType == null) {
            return true;
        }
        Class<?> rawKeyType = keyType.getRawClass();
        return (rawKeyType == String.class || rawKeyType == Object.class) && this.isDefaultKeyDeserializer(keyDeser);
    }

    public void setIgnorableProperties(String[] ignorable) {
        this._ignorableProperties = ignorable == null || ignorable.length == 0 ? null : ArrayBuilders.arrayToSet(ignorable);
    }

    public void setIgnorableProperties(Set<String> ignorable) {
        this._ignorableProperties = ignorable == null || ignorable.size() == 0 ? null : ignorable;
    }

    @Override
    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        if (this._valueInstantiator != null) {
            JavaType delegateType;
            if (this._valueInstantiator.canCreateUsingDelegate()) {
                delegateType = this._valueInstantiator.getDelegateType(ctxt.getConfig());
                if (delegateType == null) {
                    throw new IllegalArgumentException("Invalid delegate-creator definition for " + this._mapType + ": value instantiator (" + this._valueInstantiator.getClass().getName() + ") returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'");
                }
                this._delegateDeserializer = this.findDeserializer(ctxt, delegateType, null);
            } else if (this._valueInstantiator.canCreateUsingArrayDelegate()) {
                delegateType = this._valueInstantiator.getArrayDelegateType(ctxt.getConfig());
                if (delegateType == null) {
                    throw new IllegalArgumentException("Invalid delegate-creator definition for " + this._mapType + ": value instantiator (" + this._valueInstantiator.getClass().getName() + ") returned true for 'canCreateUsingDelegate()', but null for 'getArrayDelegateType()'");
                }
                this._delegateDeserializer = this.findDeserializer(ctxt, delegateType, null);
            }
        }
        if (this._valueInstantiator.canCreateFromObjectWith()) {
            SettableBeanProperty[] creatorProps = this._valueInstantiator.getFromObjectArguments(ctxt.getConfig());
            this._propertyBasedCreator = PropertyBasedCreator.construct(ctxt, this._valueInstantiator, creatorProps);
        }
        this._standardStringKey = this._isStdKeyDeser(this._mapType, this._keyDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property2) throws JsonMappingException {
        Set<String> ignoresToAdd;
        JsonIgnoreProperties.Value ignorals;
        AnnotatedMember member;
        KeyDeserializer kd = this._keyDeserializer;
        if (kd == null) {
            kd = ctxt.findKeyDeserializer(this._mapType.getKeyType(), property2);
        } else if (kd instanceof ContextualKeyDeserializer) {
            kd = ((ContextualKeyDeserializer)((Object)kd)).createContextual(ctxt, property2);
        }
        JsonDeserializer<Object> vd = this._valueDeserializer;
        if (property2 != null) {
            vd = this.findConvertingContentDeserializer(ctxt, property2, vd);
        }
        JavaType vt = this._mapType.getContentType();
        vd = vd == null ? ctxt.findContextualValueDeserializer(vt, property2) : ctxt.handleSecondaryContextualization(vd, property2, vt);
        TypeDeserializer vtd = this._valueTypeDeserializer;
        if (vtd != null) {
            vtd = vtd.forProperty(property2);
        }
        Set<String> ignored = this._ignorableProperties;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (intr != null && property2 != null && (member = property2.getMember()) != null && (ignorals = intr.findPropertyIgnorals(member)) != null && !(ignoresToAdd = ignorals.findIgnoredForDeserialization()).isEmpty()) {
            ignored = ignored == null ? new HashSet<String>() : new HashSet<String>(ignored);
            for (String str : ignoresToAdd) {
                ignored.add(str);
            }
        }
        return this.withResolved(kd, vtd, vd, ignored);
    }

    @Override
    public JavaType getContentType() {
        return this._mapType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._keyDeserializer == null && this._valueTypeDeserializer == null && this._ignorableProperties == null;
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingCreator(p2, ctxt);
        }
        if (this._delegateDeserializer != null) {
            return (Map)this._valueInstantiator.createUsingDelegate(ctxt, this._delegateDeserializer.deserialize(p2, ctxt));
        }
        if (!this._hasDefaultCreator) {
            return (Map)ctxt.handleMissingInstantiator(this.getMapClass(), p2, "no default constructor found", new Object[0]);
        }
        JsonToken t = p2.getCurrentToken();
        if (t != JsonToken.START_OBJECT && t != JsonToken.FIELD_NAME && t != JsonToken.END_OBJECT) {
            if (t == JsonToken.VALUE_STRING) {
                return (Map)this._valueInstantiator.createFromString(ctxt, p2.getText());
            }
            return (Map)this._deserializeFromEmpty(p2, ctxt);
        }
        Map result2 = (Map)this._valueInstantiator.createUsingDefault(ctxt);
        if (this._standardStringKey) {
            this._readAndBindStringKeyMap(p2, ctxt, result2);
            return result2;
        }
        this._readAndBind(p2, ctxt, result2);
        return result2;
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser p2, DeserializationContext ctxt, Map<Object, Object> result2) throws IOException {
        p2.setCurrentValue(result2);
        JsonToken t = p2.getCurrentToken();
        if (t != JsonToken.START_OBJECT && t != JsonToken.FIELD_NAME) {
            return (Map)ctxt.handleUnexpectedToken(this.getMapClass(), p2);
        }
        if (this._standardStringKey) {
            this._readAndBindStringKeyMap(p2, ctxt, result2);
            return result2;
        }
        this._readAndBind(p2, ctxt, result2);
        return result2;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    public final Class<?> getMapClass() {
        return this._mapType.getRawClass();
    }

    @Override
    public JavaType getValueType() {
        return this._mapType;
    }

    protected final void _readAndBind(JsonParser p2, DeserializationContext ctxt, Map<Object, Object> result2) throws IOException {
        String keyStr;
        boolean useObjectId;
        KeyDeserializer keyDes = this._keyDeserializer;
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        MapReferringAccumulator referringAccumulator = null;
        boolean bl = useObjectId = valueDes.getObjectIdReader() != null;
        if (useObjectId) {
            referringAccumulator = new MapReferringAccumulator(this._mapType.getContentType().getRawClass(), result2);
        }
        if (p2.isExpectedStartObjectToken()) {
            keyStr = p2.nextFieldName();
        } else {
            JsonToken t = p2.getCurrentToken();
            if (t == JsonToken.END_OBJECT) {
                return;
            }
            if (t != JsonToken.FIELD_NAME) {
                ctxt.reportWrongTokenException(p2, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            keyStr = p2.getCurrentName();
        }
        while (keyStr != null) {
            Object key2 = keyDes.deserializeKey(keyStr, ctxt);
            JsonToken t = p2.nextToken();
            if (this._ignorableProperties != null && this._ignorableProperties.contains(keyStr)) {
                p2.skipChildren();
            } else {
                try {
                    Object value2 = t == JsonToken.VALUE_NULL ? valueDes.getNullValue(ctxt) : (typeDeser == null ? valueDes.deserialize(p2, ctxt) : valueDes.deserializeWithType(p2, ctxt, typeDeser));
                    if (useObjectId) {
                        referringAccumulator.put(key2, value2);
                    } else {
                        result2.put(key2, value2);
                    }
                }
                catch (UnresolvedForwardReference reference) {
                    this.handleUnresolvedReference(p2, referringAccumulator, key2, reference);
                }
                catch (Exception e) {
                    this.wrapAndThrow(e, result2, keyStr);
                }
            }
            keyStr = p2.nextFieldName();
        }
    }

    protected final void _readAndBindStringKeyMap(JsonParser p2, DeserializationContext ctxt, Map<Object, Object> result2) throws IOException {
        JsonToken t;
        String key2;
        boolean useObjectId;
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        MapReferringAccumulator referringAccumulator = null;
        boolean bl = useObjectId = valueDes.getObjectIdReader() != null;
        if (useObjectId) {
            referringAccumulator = new MapReferringAccumulator(this._mapType.getContentType().getRawClass(), result2);
        }
        if (p2.isExpectedStartObjectToken()) {
            key2 = p2.nextFieldName();
        } else {
            t = p2.getCurrentToken();
            if (t == JsonToken.END_OBJECT) {
                return;
            }
            if (t != JsonToken.FIELD_NAME) {
                ctxt.reportWrongTokenException(p2, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            key2 = p2.getCurrentName();
        }
        while (key2 != null) {
            t = p2.nextToken();
            if (this._ignorableProperties != null && this._ignorableProperties.contains(key2)) {
                p2.skipChildren();
            } else {
                try {
                    Object value2 = t == JsonToken.VALUE_NULL ? valueDes.getNullValue(ctxt) : (typeDeser == null ? valueDes.deserialize(p2, ctxt) : valueDes.deserializeWithType(p2, ctxt, typeDeser));
                    if (useObjectId) {
                        referringAccumulator.put(key2, value2);
                    } else {
                        result2.put(key2, value2);
                    }
                }
                catch (UnresolvedForwardReference reference) {
                    this.handleUnresolvedReference(p2, referringAccumulator, key2, reference);
                }
                catch (Exception e) {
                    this.wrapAndThrow(e, result2, key2);
                }
            }
            key2 = p2.nextFieldName();
        }
    }

    public Map<Object, Object> _deserializeUsingCreator(JsonParser p2, DeserializationContext ctxt) throws IOException {
        PropertyBasedCreator creator = this._propertyBasedCreator;
        PropertyValueBuffer buffer2 = creator.startBuilding(p2, ctxt, null);
        JsonDeserializer<Object> valueDes = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        String key2 = p2.isExpectedStartObjectToken() ? p2.nextFieldName() : (p2.hasToken(JsonToken.FIELD_NAME) ? p2.getCurrentName() : null);
        while (key2 != null) {
            JsonToken t = p2.nextToken();
            if (this._ignorableProperties != null && this._ignorableProperties.contains(key2)) {
                p2.skipChildren();
            } else {
                SettableBeanProperty prop = creator.findCreatorProperty(key2);
                if (prop != null) {
                    if (buffer2.assignParameter(prop, prop.deserialize(p2, ctxt))) {
                        Map result2;
                        p2.nextToken();
                        try {
                            result2 = (Map)creator.build(ctxt, buffer2);
                        }
                        catch (Exception e) {
                            this.wrapAndThrow(e, this._mapType.getRawClass(), key2);
                            return null;
                        }
                        this._readAndBind(p2, ctxt, result2);
                        return result2;
                    }
                } else {
                    Object value2;
                    Object actualKey = this._keyDeserializer.deserializeKey(key2, ctxt);
                    try {
                        value2 = t == JsonToken.VALUE_NULL ? valueDes.getNullValue(ctxt) : (typeDeser == null ? valueDes.deserialize(p2, ctxt) : valueDes.deserializeWithType(p2, ctxt, typeDeser));
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(e, this._mapType.getRawClass(), key2);
                        return null;
                    }
                    buffer2.bufferMapProperty(actualKey, value2);
                }
            }
            key2 = p2.nextFieldName();
        }
        try {
            return (Map)creator.build(ctxt, buffer2);
        }
        catch (Exception e) {
            this.wrapAndThrow(e, this._mapType.getRawClass(), key2);
            return null;
        }
    }

    @Deprecated
    protected void wrapAndThrow(Throwable t, Object ref) throws IOException {
        this.wrapAndThrow(t, ref, null);
    }

    private void handleUnresolvedReference(JsonParser jp, MapReferringAccumulator accumulator, Object key2, UnresolvedForwardReference reference) throws JsonMappingException {
        if (accumulator == null) {
            throw JsonMappingException.from(jp, "Unresolved forward reference but no identity info.", (Throwable)reference);
        }
        ReadableObjectId.Referring referring = accumulator.handleUnresolvedReference(reference, key2);
        reference.getRoid().appendReferring(referring);
    }

    static class MapReferring
    extends ReadableObjectId.Referring {
        private final MapReferringAccumulator _parent;
        public final Map<Object, Object> next = new LinkedHashMap<Object, Object>();
        public final Object key;

        MapReferring(MapReferringAccumulator parent, UnresolvedForwardReference ref, Class<?> valueType, Object key2) {
            super(ref, valueType);
            this._parent = parent;
            this.key = key2;
        }

        @Override
        public void handleResolvedForwardReference(Object id, Object value2) throws IOException {
            this._parent.resolveForwardReference(id, value2);
        }
    }

    private static final class MapReferringAccumulator {
        private final Class<?> _valueType;
        private Map<Object, Object> _result;
        private List<MapReferring> _accumulator = new ArrayList<MapReferring>();

        public MapReferringAccumulator(Class<?> valueType, Map<Object, Object> result2) {
            this._valueType = valueType;
            this._result = result2;
        }

        public void put(Object key2, Object value2) {
            if (this._accumulator.isEmpty()) {
                this._result.put(key2, value2);
            } else {
                MapReferring ref = this._accumulator.get(this._accumulator.size() - 1);
                ref.next.put(key2, value2);
            }
        }

        public ReadableObjectId.Referring handleUnresolvedReference(UnresolvedForwardReference reference, Object key2) {
            MapReferring id = new MapReferring(this, reference, this._valueType, key2);
            this._accumulator.add(id);
            return id;
        }

        public void resolveForwardReference(Object id, Object value2) throws IOException {
            Iterator<MapReferring> iterator2 = this._accumulator.iterator();
            Map<Object, Object> previous = this._result;
            while (iterator2.hasNext()) {
                MapReferring ref = iterator2.next();
                if (ref.hasId(id)) {
                    iterator2.remove();
                    previous.put(ref.key, value2);
                    previous.putAll(ref.next);
                    return;
                }
                previous = ref.next;
            }
            throw new IllegalArgumentException("Trying to resolve a forward reference with id [" + id + "] that wasn't previously seen as unresolved.");
        }
    }
}

