/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;

public class StackTraceElementDeserializer
extends StdScalarDeserializer<StackTraceElement> {
    private static final long serialVersionUID = 1L;

    public StackTraceElementDeserializer() {
        super(StackTraceElement.class);
    }

    @Override
    public StackTraceElement deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            String className = "";
            String methodName = "";
            String fileName = "";
            String moduleName = null;
            String moduleVersion = null;
            int lineNumber = -1;
            while ((t = p2.nextValue()) != JsonToken.END_OBJECT) {
                String propName = p2.getCurrentName();
                if ("className".equals(propName)) {
                    className = p2.getText();
                    continue;
                }
                if ("fileName".equals(propName)) {
                    fileName = p2.getText();
                    continue;
                }
                if ("lineNumber".equals(propName)) {
                    if (t.isNumeric()) {
                        lineNumber = p2.getIntValue();
                        continue;
                    }
                    return (StackTraceElement)ctxt.handleUnexpectedToken(this.handledType(), t, p2, "Non-numeric token (%s) for property 'lineNumber'", new Object[]{t});
                }
                if ("methodName".equals(propName)) {
                    methodName = p2.getText();
                    continue;
                }
                if ("nativeMethod".equals(propName)) continue;
                if ("moduleName".equals(propName)) {
                    moduleName = p2.getText();
                    continue;
                }
                if ("moduleVersion".equals(propName)) {
                    moduleVersion = p2.getText();
                    continue;
                }
                this.handleUnknownProperty(p2, ctxt, this._valueClass, propName);
            }
            return this.constructValue(ctxt, className, methodName, fileName, lineNumber, moduleName, moduleVersion);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p2.nextToken();
            StackTraceElement value2 = this.deserialize(p2, ctxt);
            if (p2.nextToken() != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p2, ctxt);
            }
            return value2;
        }
        return (StackTraceElement)ctxt.handleUnexpectedToken(this._valueClass, p2);
    }

    protected StackTraceElement constructValue(DeserializationContext ctxt, String className, String methodName, String fileName, int lineNumber, String moduleName, String moduleVersion) {
        return new StackTraceElement(className, methodName, fileName, lineNumber);
    }
}

