/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.Converter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public abstract class StdDeserializer<T>
extends JsonDeserializer<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final int F_MASK_INT_COERCIONS = DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.getMask() | DeserializationFeature.USE_LONG_FOR_INTS.getMask();
    protected final Class<?> _valueClass;

    protected StdDeserializer(Class<?> vc) {
        this._valueClass = vc;
    }

    protected StdDeserializer(JavaType valueType) {
        this._valueClass = valueType == null ? null : valueType.getRawClass();
    }

    protected StdDeserializer(StdDeserializer<?> src) {
        this._valueClass = src._valueClass;
    }

    @Override
    public Class<?> handledType() {
        return this._valueClass;
    }

    @Deprecated
    public final Class<?> getValueClass() {
        return this._valueClass;
    }

    public JavaType getValueType() {
        return null;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> deserializer) {
        return ClassUtil.isJacksonStdImpl(deserializer);
    }

    protected boolean isDefaultKeyDeserializer(KeyDeserializer keyDeser) {
        return ClassUtil.isJacksonStdImpl(keyDeser);
    }

    @Override
    public Object deserializeWithType(JsonParser p2, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(p2, ctxt);
    }

    protected final boolean _parseBooleanPrimitive(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return true;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return false;
        }
        if (t == JsonToken.VALUE_NULL) {
            return false;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return this._parseBooleanFromInt(p2, ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = p2.getText().trim();
            if ("true".equals(text2) || "True".equals(text2)) {
                return true;
            }
            if ("false".equals(text2) || "False".equals(text2) || text2.length() == 0) {
                return false;
            }
            if (this._hasTextualNull(text2)) {
                return false;
            }
            Boolean b = (Boolean)ctxt.handleWeirdStringValue(this._valueClass, text2, "only \"true\" or \"false\" recognized", new Object[0]);
            return b == null ? false : b;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p2.nextToken();
            boolean parsed = this._parseBooleanPrimitive(p2, ctxt);
            t = p2.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p2, ctxt);
            }
            return parsed;
        }
        return (Boolean)ctxt.handleUnexpectedToken(this._valueClass, p2);
    }

    protected final Boolean _parseBoolean(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return Boolean.TRUE;
        }
        if (t == JsonToken.VALUE_FALSE) {
            return Boolean.FALSE;
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return this._parseBooleanFromInt(p2, ctxt);
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Boolean)this.getNullValue(ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = p2.getText().trim();
            if ("true".equals(text2) || "True".equals(text2)) {
                return Boolean.TRUE;
            }
            if ("false".equals(text2) || "False".equals(text2)) {
                return Boolean.FALSE;
            }
            if (text2.length() == 0) {
                return (Boolean)this.getEmptyValue(ctxt);
            }
            if (this._hasTextualNull(text2)) {
                return (Boolean)this.getNullValue(ctxt);
            }
            return (Boolean)ctxt.handleWeirdStringValue(this._valueClass, text2, "only \"true\" or \"false\" recognized", new Object[0]);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p2.nextToken();
            Boolean parsed = this._parseBoolean(p2, ctxt);
            t = p2.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p2, ctxt);
            }
            return parsed;
        }
        return (Boolean)ctxt.handleUnexpectedToken(this._valueClass, p2);
    }

    protected boolean _parseBooleanFromInt(JsonParser p2, DeserializationContext ctxt) throws IOException {
        return !"0".equals(p2.getText());
    }

    @Deprecated
    protected boolean _parseBooleanFromOther(JsonParser p2, DeserializationContext ctxt) throws IOException {
        return this._parseBooleanFromInt(p2, ctxt);
    }

    protected Byte _parseByte(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return p2.getByteValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            int value2;
            String text2 = p2.getText().trim();
            if (this._hasTextualNull(text2)) {
                return (Byte)this.getNullValue(ctxt);
            }
            try {
                int len = text2.length();
                if (len == 0) {
                    return (Byte)this.getEmptyValue(ctxt);
                }
                value2 = NumberInput.parseInt(text2);
            }
            catch (IllegalArgumentException iae) {
                return (Byte)ctxt.handleWeirdStringValue(this._valueClass, text2, "not a valid Byte value", new Object[0]);
            }
            if (value2 < -128 || value2 > 255) {
                return (Byte)ctxt.handleWeirdStringValue(this._valueClass, text2, "overflow, value can not be represented as 8-bit value", new Object[0]);
            }
            return (byte)value2;
        }
        if (t == JsonToken.VALUE_NUMBER_FLOAT) {
            if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                this._failDoubleToIntCoercion(p2, ctxt, "Byte");
            }
            return p2.getByteValue();
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Byte)this.getNullValue(ctxt);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p2.nextToken();
            Byte parsed = this._parseByte(p2, ctxt);
            t = p2.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p2, ctxt);
            }
            return parsed;
        }
        return (Byte)ctxt.handleUnexpectedToken(this._valueClass, p2);
    }

    protected Short _parseShort(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return p2.getShortValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            int value2;
            String text2 = p2.getText().trim();
            try {
                int len = text2.length();
                if (len == 0) {
                    return (Short)this.getEmptyValue(ctxt);
                }
                if (this._hasTextualNull(text2)) {
                    return (Short)this.getNullValue(ctxt);
                }
                value2 = NumberInput.parseInt(text2);
            }
            catch (IllegalArgumentException iae) {
                return (Short)ctxt.handleWeirdStringValue(this._valueClass, text2, "not a valid Short value", new Object[0]);
            }
            if (value2 < Short.MIN_VALUE || value2 > Short.MAX_VALUE) {
                return (Short)ctxt.handleWeirdStringValue(this._valueClass, text2, "overflow, value can not be represented as 16-bit value", new Object[0]);
            }
            return (short)value2;
        }
        if (t == JsonToken.VALUE_NUMBER_FLOAT) {
            if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                this._failDoubleToIntCoercion(p2, ctxt, "Short");
            }
            return p2.getShortValue();
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Short)this.getNullValue(ctxt);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p2.nextToken();
            Short parsed = this._parseShort(p2, ctxt);
            t = p2.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p2, ctxt);
            }
            return parsed;
        }
        return (Short)ctxt.handleUnexpectedToken(this._valueClass, p2);
    }

    protected final short _parseShortPrimitive(JsonParser p2, DeserializationContext ctxt) throws IOException {
        int value2 = this._parseIntPrimitive(p2, ctxt);
        if (value2 < Short.MIN_VALUE || value2 > Short.MAX_VALUE) {
            Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, String.valueOf(value2), "overflow, value can not be represented as 16-bit value", new Object[0]);
            return v == null ? (short)0 : v.shortValue();
        }
        return (short)value2;
    }

    protected final int _parseIntPrimitive(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return p2.getIntValue();
        }
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            String text2 = p2.getText().trim();
            if (this._hasTextualNull(text2)) {
                return 0;
            }
            try {
                int len = text2.length();
                if (len > 9) {
                    long l = Long.parseLong(text2);
                    if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                        Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text2, "Overflow: numeric value (%s) out of range of int (%d -%d)", text2, Integer.MIN_VALUE, Integer.MAX_VALUE);
                        return v == null ? 0 : v.intValue();
                    }
                    return (int)l;
                }
                if (len == 0) {
                    return 0;
                }
                return NumberInput.parseInt(text2);
            }
            catch (IllegalArgumentException iae) {
                Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text2, "not a valid int value", new Object[0]);
                return v == null ? 0 : v.intValue();
            }
        }
        if (t == JsonToken.VALUE_NUMBER_FLOAT) {
            if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                this._failDoubleToIntCoercion(p2, ctxt, "int");
            }
            return p2.getValueAsInt();
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p2.nextToken();
            int parsed = this._parseIntPrimitive(p2, ctxt);
            t = p2.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p2, ctxt);
            }
            return parsed;
        }
        return ((Number)ctxt.handleUnexpectedToken(this._valueClass, p2)).intValue();
    }

    protected final Integer _parseInteger(JsonParser p2, DeserializationContext ctxt) throws IOException {
        switch (p2.getCurrentTokenId()) {
            case 7: {
                return p2.getIntValue();
            }
            case 8: {
                if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(p2, ctxt, "Integer");
                }
                return p2.getValueAsInt();
            }
            case 6: {
                String text2 = p2.getText().trim();
                try {
                    int len = text2.length();
                    if (this._hasTextualNull(text2)) {
                        return (Integer)this.getNullValue(ctxt);
                    }
                    if (len > 9) {
                        long l = Long.parseLong(text2);
                        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                            return (Integer)ctxt.handleWeirdStringValue(this._valueClass, text2, "Overflow: numeric value (" + text2 + ") out of range of Integer (" + Integer.MIN_VALUE + " - " + Integer.MAX_VALUE + ")", new Object[0]);
                        }
                        return (int)l;
                    }
                    if (len == 0) {
                        return (Integer)this.getEmptyValue(ctxt);
                    }
                    return NumberInput.parseInt(text2);
                }
                catch (IllegalArgumentException iae) {
                    return (Integer)ctxt.handleWeirdStringValue(this._valueClass, text2, "not a valid Integer value", new Object[0]);
                }
            }
            case 11: {
                return (Integer)this.getNullValue(ctxt);
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p2.nextToken();
                Integer parsed = this._parseInteger(p2, ctxt);
                if (p2.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p2, ctxt);
                }
                return parsed;
            }
        }
        return (Integer)ctxt.handleUnexpectedToken(this._valueClass, p2);
    }

    protected final Long _parseLong(JsonParser p2, DeserializationContext ctxt) throws IOException {
        switch (p2.getCurrentTokenId()) {
            case 7: {
                return p2.getLongValue();
            }
            case 8: {
                if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(p2, ctxt, "Long");
                }
                return p2.getValueAsLong();
            }
            case 6: {
                String text2 = p2.getText().trim();
                if (text2.length() == 0) {
                    return (Long)this.getEmptyValue(ctxt);
                }
                if (this._hasTextualNull(text2)) {
                    return (Long)this.getNullValue(ctxt);
                }
                try {
                    return NumberInput.parseLong(text2);
                }
                catch (IllegalArgumentException iae) {
                    return (Long)ctxt.handleWeirdStringValue(this._valueClass, text2, "not a valid Long value", new Object[0]);
                }
            }
            case 11: {
                return (Long)this.getNullValue(ctxt);
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p2.nextToken();
                Long parsed = this._parseLong(p2, ctxt);
                JsonToken t = p2.nextToken();
                if (t != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p2, ctxt);
                }
                return parsed;
            }
        }
        return (Long)ctxt.handleUnexpectedToken(this._valueClass, p2);
    }

    protected final long _parseLongPrimitive(JsonParser p2, DeserializationContext ctxt) throws IOException {
        switch (p2.getCurrentTokenId()) {
            case 7: {
                return p2.getLongValue();
            }
            case 8: {
                if (!ctxt.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT)) {
                    this._failDoubleToIntCoercion(p2, ctxt, "long");
                }
                return p2.getValueAsLong();
            }
            case 6: {
                String text2 = p2.getText().trim();
                if (text2.length() == 0 || this._hasTextualNull(text2)) {
                    return 0L;
                }
                try {
                    return NumberInput.parseLong(text2);
                }
                catch (IllegalArgumentException iae) {
                    Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text2, "not a valid long value", new Object[0]);
                    return v == null ? 0L : v.longValue();
                }
            }
            case 11: {
                return 0L;
            }
            case 3: {
                if (!ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) break;
                p2.nextToken();
                long parsed = this._parseLongPrimitive(p2, ctxt);
                JsonToken t = p2.nextToken();
                if (t != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(p2, ctxt);
                }
                return parsed;
            }
        }
        return ((Number)ctxt.handleUnexpectedToken(this._valueClass, p2)).longValue();
    }

    protected final Float _parseFloat(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return Float.valueOf(p2.getFloatValue());
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = p2.getText().trim();
            if (text2.length() == 0) {
                return (Float)this.getEmptyValue(ctxt);
            }
            if (this._hasTextualNull(text2)) {
                return (Float)this.getNullValue(ctxt);
            }
            switch (text2.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text2)) break;
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                case 'N': {
                    if (!this._isNaN(text2)) break;
                    return Float.valueOf(Float.NaN);
                }
                case '-': {
                    if (!this._isNegInf(text2)) break;
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
            }
            try {
                return Float.valueOf(Float.parseFloat(text2));
            }
            catch (IllegalArgumentException iae) {
                return (Float)ctxt.handleWeirdStringValue(this._valueClass, text2, "not a valid Float value", new Object[0]);
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Float)this.getNullValue(ctxt);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p2.nextToken();
            Float parsed = this._parseFloat(p2, ctxt);
            t = p2.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p2, ctxt);
            }
            return parsed;
        }
        return (Float)ctxt.handleUnexpectedToken(this._valueClass, p2);
    }

    protected final float _parseFloatPrimitive(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return p2.getFloatValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = p2.getText().trim();
            if (text2.length() == 0 || this._hasTextualNull(text2)) {
                return 0.0f;
            }
            switch (text2.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text2)) break;
                    return Float.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text2)) break;
                    return Float.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text2)) break;
                    return Float.NEGATIVE_INFINITY;
                }
            }
            try {
                return Float.parseFloat(text2);
            }
            catch (IllegalArgumentException iae) {
                Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text2, "not a valid float value", new Object[0]);
                return v == null ? 0.0f : v.floatValue();
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0.0f;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p2.nextToken();
            float parsed = this._parseFloatPrimitive(p2, ctxt);
            t = p2.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p2, ctxt);
            }
            return parsed;
        }
        return ((Number)ctxt.handleUnexpectedToken(this._valueClass, p2)).floatValue();
    }

    protected final Double _parseDouble(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return p2.getDoubleValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = p2.getText().trim();
            if (text2.length() == 0) {
                return (Double)this.getEmptyValue(ctxt);
            }
            if (this._hasTextualNull(text2)) {
                return (Double)this.getNullValue(ctxt);
            }
            switch (text2.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text2)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text2)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text2)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(text2);
            }
            catch (IllegalArgumentException iae) {
                return (Double)ctxt.handleWeirdStringValue(this._valueClass, text2, "not a valid Double value", new Object[0]);
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Double)this.getNullValue(ctxt);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p2.nextToken();
            Double parsed = this._parseDouble(p2, ctxt);
            t = p2.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p2, ctxt);
            }
            return parsed;
        }
        return (Double)ctxt.handleUnexpectedToken(this._valueClass, p2);
    }

    protected final double _parseDoublePrimitive(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            return p2.getDoubleValue();
        }
        if (t == JsonToken.VALUE_STRING) {
            String text2 = p2.getText().trim();
            if (text2.length() == 0 || this._hasTextualNull(text2)) {
                return 0.0;
            }
            switch (text2.charAt(0)) {
                case 'I': {
                    if (!this._isPosInf(text2)) break;
                    return Double.POSITIVE_INFINITY;
                }
                case 'N': {
                    if (!this._isNaN(text2)) break;
                    return Double.NaN;
                }
                case '-': {
                    if (!this._isNegInf(text2)) break;
                    return Double.NEGATIVE_INFINITY;
                }
            }
            try {
                return StdDeserializer.parseDouble(text2);
            }
            catch (IllegalArgumentException iae) {
                Number v = (Number)ctxt.handleWeirdStringValue(this._valueClass, text2, "not a valid double value", new Object[0]);
                return v == null ? 0.0 : v.doubleValue();
            }
        }
        if (t == JsonToken.VALUE_NULL) {
            return 0.0;
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p2.nextToken();
            double parsed = this._parseDoublePrimitive(p2, ctxt);
            t = p2.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p2, ctxt);
            }
            return parsed;
        }
        return ((Number)ctxt.handleUnexpectedToken(this._valueClass, p2)).doubleValue();
    }

    protected Date _parseDate(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new Date(p2.getLongValue());
        }
        if (t == JsonToken.VALUE_NULL) {
            return (Date)this.getNullValue(ctxt);
        }
        if (t == JsonToken.VALUE_STRING) {
            return this._parseDate(p2.getText().trim(), ctxt);
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p2.nextToken();
            Date parsed = this._parseDate(p2, ctxt);
            t = p2.nextToken();
            if (t != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p2, ctxt);
            }
            return parsed;
        }
        return (Date)ctxt.handleUnexpectedToken(this._valueClass, p2);
    }

    protected Date _parseDate(String value2, DeserializationContext ctxt) throws IOException {
        try {
            if (value2.length() == 0) {
                return (Date)this.getEmptyValue(ctxt);
            }
            if (this._hasTextualNull(value2)) {
                return (Date)this.getNullValue(ctxt);
            }
            return ctxt.parseDate(value2);
        }
        catch (IllegalArgumentException iae) {
            return (Date)ctxt.handleWeirdStringValue(this._valueClass, value2, "not a valid representation (error: %s)", iae.getMessage());
        }
    }

    protected static final double parseDouble(String numStr2) throws NumberFormatException {
        if ("2.2250738585072012e-308".equals(numStr2)) {
            return Double.MIN_NORMAL;
        }
        return Double.parseDouble(numStr2);
    }

    protected final String _parseString(JsonParser p2, DeserializationContext ctxt) throws IOException {
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.VALUE_STRING) {
            return p2.getText();
        }
        if (t == JsonToken.START_ARRAY && ctxt.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
            p2.nextToken();
            String parsed = this._parseString(p2, ctxt);
            if (p2.nextToken() != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle(p2, ctxt);
            }
            return parsed;
        }
        String value2 = p2.getValueAsString();
        if (value2 != null) {
            return value2;
        }
        return (String)ctxt.handleUnexpectedToken(String.class, p2);
    }

    protected T _deserializeFromEmpty(JsonParser p2, DeserializationContext ctxt) throws IOException {
        String str;
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.START_ARRAY) {
            if (ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT)) {
                t = p2.nextToken();
                if (t == JsonToken.END_ARRAY) {
                    return null;
                }
                return (T)ctxt.handleUnexpectedToken(this.handledType(), p2);
            }
        } else if (t == JsonToken.VALUE_STRING && ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (str = p2.getText().trim()).isEmpty()) {
            return null;
        }
        return (T)ctxt.handleUnexpectedToken(this.handledType(), p2);
    }

    protected boolean _hasTextualNull(String value2) {
        return "null".equals(value2);
    }

    protected final boolean _isNegInf(String text2) {
        return "-Infinity".equals(text2) || "-INF".equals(text2);
    }

    protected final boolean _isPosInf(String text2) {
        return "Infinity".equals(text2) || "INF".equals(text2);
    }

    protected final boolean _isNaN(String text2) {
        return "NaN".equals(text2);
    }

    protected Object _coerceIntegral(JsonParser p2, DeserializationContext ctxt) throws IOException {
        int feats = ctxt.getDeserializationFeatures();
        if (DeserializationFeature.USE_BIG_INTEGER_FOR_INTS.enabledIn(feats)) {
            return p2.getBigIntegerValue();
        }
        if (DeserializationFeature.USE_LONG_FOR_INTS.enabledIn(feats)) {
            return p2.getLongValue();
        }
        return p2.getBigIntegerValue();
    }

    protected JsonDeserializer<Object> findDeserializer(DeserializationContext ctxt, JavaType type, BeanProperty property2) throws JsonMappingException {
        return ctxt.findContextualValueDeserializer(type, property2);
    }

    protected final boolean _isIntNumber(String text2) {
        int len = text2.length();
        if (len > 0) {
            int i;
            char c = text2.charAt(0);
            int n = i = c == '-' || c == '+' ? 1 : 0;
            while (i < len) {
                char ch = text2.charAt(i);
                if (ch > '9' || ch < '0') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected JsonDeserializer<?> findConvertingContentDeserializer(DeserializationContext ctxt, BeanProperty prop, JsonDeserializer<?> existingDeserializer) throws JsonMappingException {
        Object convDef;
        AnnotatedMember member;
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        if (intr != null && prop != null && (member = prop.getMember()) != null && (convDef = intr.findDeserializationContentConverter(member)) != null) {
            Converter<Object, Object> conv = ctxt.converterInstance(prop.getMember(), convDef);
            JavaType delegateType = conv.getInputType(ctxt.getTypeFactory());
            if (existingDeserializer == null) {
                existingDeserializer = ctxt.findContextualValueDeserializer(delegateType, prop);
            }
            return new StdDelegatingDeserializer<Object>(conv, delegateType, existingDeserializer);
        }
        return existingDeserializer;
    }

    protected JsonFormat.Value findFormatOverrides(DeserializationContext ctxt, BeanProperty prop, Class<?> typeForDefaults) {
        if (prop != null) {
            return prop.findPropertyFormat(ctxt.getConfig(), typeForDefaults);
        }
        return ctxt.getDefaultPropertyFormat(typeForDefaults);
    }

    protected Boolean findFormatFeature(DeserializationContext ctxt, BeanProperty prop, Class<?> typeForDefaults, JsonFormat.Feature feat) {
        JsonFormat.Value format2 = this.findFormatOverrides(ctxt, prop, typeForDefaults);
        if (format2 != null) {
            return format2.getFeature(feat);
        }
        return null;
    }

    protected void handleUnknownProperty(JsonParser p2, DeserializationContext ctxt, Object instanceOrClass, String propName) throws IOException {
        if (instanceOrClass == null) {
            instanceOrClass = this.handledType();
        }
        if (ctxt.handleUnknownProperty(p2, this, instanceOrClass, propName)) {
            return;
        }
        p2.skipChildren();
    }

    protected void handleMissingEndArrayForSingle(JsonParser p2, DeserializationContext ctxt) throws IOException {
        ctxt.reportWrongTokenException(p2, JsonToken.END_ARRAY, "Attempted to unwrap single value array for single '%s' value but there was more than a single value in the array", this.handledType().getName());
    }

    protected void _failDoubleToIntCoercion(JsonParser p2, DeserializationContext ctxt, String type) throws IOException {
        ctxt.reportMappingException("Can not coerce a floating-point value ('%s') into %s; enable `DeserializationFeature.ACCEPT_FLOAT_AS_INT` to allow", p2.getValueAsString(), type);
    }
}

