/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;

@JacksonStdImpl
public final class StringArrayDeserializer
extends StdDeserializer<String[]>
implements ContextualDeserializer {
    private static final long serialVersionUID = 2L;
    public static final StringArrayDeserializer instance = new StringArrayDeserializer();
    protected JsonDeserializer<String> _elementDeserializer;
    protected final Boolean _unwrapSingle;

    public StringArrayDeserializer() {
        this(null, null);
    }

    protected StringArrayDeserializer(JsonDeserializer<?> deser, Boolean unwrapSingle) {
        super(String[].class);
        this._elementDeserializer = deser;
        this._unwrapSingle = unwrapSingle;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property2) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._elementDeserializer;
        deser = this.findConvertingContentDeserializer(ctxt, property2, deser);
        JavaType type = ctxt.constructType(String.class);
        deser = deser == null ? ctxt.findContextualValueDeserializer(type, property2) : ctxt.handleSecondaryContextualization(deser, property2, type);
        Boolean unwrapSingle = this.findFormatFeature(ctxt, property2, String[].class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (deser != null && this.isDefaultDeserializer(deser)) {
            deser = null;
        }
        if (this._elementDeserializer == deser && this._unwrapSingle == unwrapSingle) {
            return this;
        }
        return new StringArrayDeserializer(deser, unwrapSingle);
    }

    @Override
    public String[] deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (!p2.isExpectedStartArrayToken()) {
            return this.handleNonArray(p2, ctxt);
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(p2, ctxt);
        }
        ObjectBuffer buffer2 = ctxt.leaseObjectBuffer();
        Object[] chunk = buffer2.resetAndStart();
        int ix = 0;
        try {
            while (true) {
                String value2;
                if ((value2 = p2.nextTextValue()) == null) {
                    JsonToken t = p2.getCurrentToken();
                    if (t == JsonToken.END_ARRAY) break;
                    if (t != JsonToken.VALUE_NULL) {
                        value2 = this._parseString(p2, ctxt);
                    }
                }
                if (ix >= chunk.length) {
                    chunk = buffer2.appendCompletedChunk(chunk);
                    ix = 0;
                }
                chunk[ix++] = value2;
            }
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, (Object)chunk, buffer2.bufferedSize() + ix);
        }
        String[] result2 = buffer2.completeAndClearBuffer(chunk, ix, String.class);
        ctxt.returnObjectBuffer(buffer2);
        return result2;
    }

    protected final String[] _deserializeCustom(JsonParser p2, DeserializationContext ctxt) throws IOException {
        ObjectBuffer buffer2 = ctxt.leaseObjectBuffer();
        Object[] chunk = buffer2.resetAndStart();
        JsonDeserializer<String> deser = this._elementDeserializer;
        int ix = 0;
        try {
            while (true) {
                String value2;
                if (p2.nextTextValue() == null) {
                    JsonToken t = p2.getCurrentToken();
                    if (t == JsonToken.END_ARRAY) break;
                    value2 = t == JsonToken.VALUE_NULL ? deser.getNullValue(ctxt) : deser.deserialize(p2, ctxt);
                } else {
                    value2 = deser.deserialize(p2, ctxt);
                }
                if (ix >= chunk.length) {
                    chunk = buffer2.appendCompletedChunk(chunk);
                    ix = 0;
                }
                chunk[ix++] = value2;
            }
        }
        catch (Exception e) {
            throw JsonMappingException.wrapWithPath((Throwable)e, String.class, ix);
        }
        String[] result2 = buffer2.completeAndClearBuffer(chunk, ix, String.class);
        ctxt.returnObjectBuffer(buffer2);
        return result2;
    }

    @Override
    public Object deserializeWithType(JsonParser p2, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(p2, ctxt);
    }

    private final String[] handleNonArray(JsonParser p2, DeserializationContext ctxt) throws IOException {
        String str;
        boolean canWrap;
        boolean bl = canWrap = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && ctxt.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (canWrap) {
            return new String[]{p2.hasToken(JsonToken.VALUE_NULL) ? null : this._parseString(p2, ctxt)};
        }
        if (p2.hasToken(JsonToken.VALUE_STRING) && ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (str = p2.getText()).length() == 0) {
            return null;
        }
        return (String[])ctxt.handleUnexpectedToken(this._valueClass, p2);
    }
}

