/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jdk8;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.Optional;

final class OptionalDeserializer
extends StdDeserializer<Optional<?>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _fullType;
    protected final JsonDeserializer<?> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;

    public OptionalDeserializer(JavaType fullType, TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        super(fullType);
        this._fullType = fullType;
        this._valueTypeDeserializer = typeDeser;
        this._valueDeserializer = valueDeser;
    }

    protected OptionalDeserializer withResolved(TypeDeserializer typeDeser, JsonDeserializer<?> valueDeser) {
        if (valueDeser == this._valueDeserializer && typeDeser == this._valueTypeDeserializer) {
            return this;
        }
        return new OptionalDeserializer(this._fullType, typeDeser, valueDeser);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property2) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._valueDeserializer;
        TypeDeserializer typeDeser = this._valueTypeDeserializer;
        JavaType refType = this._fullType.getReferencedType();
        deser = deser == null ? ctxt.findContextualValueDeserializer(refType, property2) : ctxt.handleSecondaryContextualization(deser, property2, refType);
        if (typeDeser != null) {
            typeDeser = typeDeser.forProperty(property2);
        }
        return this.withResolved(typeDeser, deser);
    }

    @Override
    public JavaType getValueType() {
        return this._fullType;
    }

    @Override
    public Optional<?> getNullValue(DeserializationContext ctxt) {
        return Optional.empty();
    }

    @Override
    public Optional<?> deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        Object refd = this._valueTypeDeserializer == null ? this._valueDeserializer.deserialize(p2, ctxt) : this._valueDeserializer.deserializeWithType(p2, ctxt, this._valueTypeDeserializer);
        return Optional.ofNullable(refd);
    }

    @Override
    public Optional<?> deserializeWithType(JsonParser p2, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        JsonToken t = p2.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return this.getNullValue(ctxt);
        }
        if (t != null && t.isScalarValue()) {
            return this.deserialize(p2, ctxt);
        }
        return (Optional)typeDeserializer.deserializeTypedFromAny(p2, ctxt);
    }
}

