/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.function.BiFunction;
import java.util.function.Function;

public class InstantDeserializer<T extends Temporal>
extends JSR310DateTimeDeserializerBase<T> {
    private static final long serialVersionUID = 1L;
    public static final InstantDeserializer<Instant> INSTANT = new InstantDeserializer<Instant>(Instant.class, DateTimeFormatter.ISO_INSTANT, Instant::from, a2 -> Instant.ofEpochMilli(a2.value), a2 -> Instant.ofEpochSecond(a2.integer, a2.fraction), null, true);
    public static final InstantDeserializer<OffsetDateTime> OFFSET_DATE_TIME = new InstantDeserializer<OffsetDateTime>(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, OffsetDateTime::from, a2 -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(a2.value), a2.zoneId), a2 -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(a2.integer, a2.fraction), a2.zoneId), (d, z) -> d.withOffsetSameInstant(z.getRules().getOffset(d.toLocalDateTime())), true);
    public static final InstantDeserializer<ZonedDateTime> ZONED_DATE_TIME = new InstantDeserializer<ZonedDateTime>(ZonedDateTime.class, DateTimeFormatter.ISO_ZONED_DATE_TIME, ZonedDateTime::from, a2 -> ZonedDateTime.ofInstant(Instant.ofEpochMilli(a2.value), a2.zoneId), a2 -> ZonedDateTime.ofInstant(Instant.ofEpochSecond(a2.integer, a2.fraction), a2.zoneId), ZonedDateTime::withZoneSameInstant, false);
    protected final Function<FromIntegerArguments, T> fromMilliseconds;
    protected final Function<FromDecimalArguments, T> fromNanoseconds;
    protected final Function<TemporalAccessor, T> parsedToValue;
    protected final BiFunction<T, ZoneId, T> adjust;
    protected final boolean replace0000AsZ;
    protected final Boolean _adjustToContextTZOverride;

    protected InstantDeserializer(Class<T> supportedType, DateTimeFormatter formatter, Function<TemporalAccessor, T> parsedToValue, Function<FromIntegerArguments, T> fromMilliseconds, Function<FromDecimalArguments, T> fromNanoseconds, BiFunction<T, ZoneId, T> adjust, boolean replace0000AsZ) {
        super(supportedType, formatter);
        this.parsedToValue = parsedToValue;
        this.fromMilliseconds = fromMilliseconds;
        this.fromNanoseconds = fromNanoseconds;
        this.adjust = adjust == null ? (d, z) -> d : adjust;
        this.replace0000AsZ = replace0000AsZ;
        this._adjustToContextTZOverride = null;
    }

    protected InstantDeserializer(InstantDeserializer<T> base2, DateTimeFormatter f) {
        super(base2.handledType(), f);
        this.parsedToValue = base2.parsedToValue;
        this.fromMilliseconds = base2.fromMilliseconds;
        this.fromNanoseconds = base2.fromNanoseconds;
        this.adjust = base2.adjust;
        this.replace0000AsZ = this._formatter == DateTimeFormatter.ISO_INSTANT;
        this._adjustToContextTZOverride = base2._adjustToContextTZOverride;
    }

    protected InstantDeserializer(InstantDeserializer<T> base2, Boolean adjustToContextTimezoneOverride) {
        super(base2.handledType(), base2._formatter);
        this.parsedToValue = base2.parsedToValue;
        this.fromMilliseconds = base2.fromMilliseconds;
        this.fromNanoseconds = base2.fromNanoseconds;
        this.adjust = base2.adjust;
        this.replace0000AsZ = base2.replace0000AsZ;
        this._adjustToContextTZOverride = adjustToContextTimezoneOverride;
    }

    @Override
    protected JsonDeserializer<T> withDateFormat(DateTimeFormatter dtf) {
        if (dtf == this._formatter) {
            return this;
        }
        return new InstantDeserializer<T>(this, dtf);
    }

    @Override
    public T deserialize(JsonParser parser, DeserializationContext context2) throws IOException {
        switch (parser.getCurrentTokenId()) {
            case 8: {
                return this._fromDecimal(context2, parser.getDecimalValue());
            }
            case 7: {
                return this._fromLong(context2, parser.getLongValue());
            }
            case 6: {
                Temporal value2;
                String string2 = parser.getText().trim();
                if (string2.length() == 0) {
                    return null;
                }
                if (this._formatter == DateTimeFormatter.ISO_INSTANT || this._formatter == DateTimeFormatter.ISO_OFFSET_DATE_TIME || this._formatter == DateTimeFormatter.ISO_ZONED_DATE_TIME) {
                    int dots = this._countPeriods(string2);
                    if (dots >= 0) {
                        try {
                            if (dots == 0) {
                                return this._fromLong(context2, Long.parseLong(string2));
                            }
                            if (dots == 1) {
                                return this._fromDecimal(context2, new BigDecimal(string2));
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (this.replace0000AsZ && string2.endsWith("+0000")) {
                        string2 = string2.substring(0, string2.length() - 5) + "Z";
                    }
                }
                try {
                    TemporalAccessor acc = this._formatter.parse(string2);
                    value2 = (Temporal)this.parsedToValue.apply(acc);
                    if (this.shouldAdjustToContextTimezone(context2)) {
                        return (T)((Temporal)this.adjust.apply(value2, this.getZone(context2)));
                    }
                }
                catch (DateTimeException e) {
                    value2 = (Temporal)this._rethrowDateTimeException(parser, context2, e, string2);
                }
                return (T)value2;
            }
            case 12: {
                return (T)((Temporal)parser.getEmbeddedObject());
            }
        }
        throw context2.mappingException("Expected type float, integer, or string.");
    }

    @Override
    public JsonDeserializer<T> createContextual(DeserializationContext ctxt, BeanProperty property2) throws JsonMappingException {
        JsonFormat.Value val;
        InstantDeserializer deserializer = (InstantDeserializer)super.createContextual(ctxt, property2);
        if (deserializer != this && (val = this.findFormatOverrides(ctxt, property2, this.handledType())) != null) {
            return new InstantDeserializer<T>(deserializer, val.getFeature(JsonFormat.Feature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE));
        }
        return this;
    }

    protected boolean shouldAdjustToContextTimezone(DeserializationContext context2) {
        return this._adjustToContextTZOverride != null ? this._adjustToContextTZOverride.booleanValue() : context2.isEnabled(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE);
    }

    protected int _countPeriods(String str) {
        int commas = 0;
        int end = str.length();
        for (int i = 0; i < end; ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            if (ch == '.') {
                ++commas;
                continue;
            }
            return -1;
        }
        return commas;
    }

    protected T _fromLong(DeserializationContext context2, long timestamp) {
        if (context2.isEnabled(DeserializationFeature.READ_DATE_TIMESTAMPS_AS_NANOSECONDS)) {
            return (T)((Temporal)this.fromNanoseconds.apply(new FromDecimalArguments(timestamp, 0, this.getZone(context2))));
        }
        return (T)((Temporal)this.fromMilliseconds.apply(new FromIntegerArguments(timestamp, this.getZone(context2))));
    }

    protected T _fromDecimal(DeserializationContext context2, BigDecimal value2) {
        long seconds = value2.longValue();
        int nanoseconds = DecimalUtils.extractNanosecondDecimal(value2, seconds);
        return (T)((Temporal)this.fromNanoseconds.apply(new FromDecimalArguments(seconds, nanoseconds, this.getZone(context2))));
    }

    private ZoneId getZone(DeserializationContext context2) {
        return this._valueClass == Instant.class ? null : context2.getTimeZone().toZoneId();
    }

    public static class FromDecimalArguments {
        public final long integer;
        public final int fraction;
        public final ZoneId zoneId;

        private FromDecimalArguments(long integer, int fraction, ZoneId zoneId) {
            this.integer = integer;
            this.fraction = fraction;
            this.zoneId = zoneId;
        }
    }

    public static class FromIntegerArguments {
        public final long value;
        public final ZoneId zoneId;

        private FromIntegerArguments(long value2, ZoneId zoneId) {
            this.value = value2;
            this.zoneId = zoneId;
        }
    }
}

