/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.jsr310.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class LocalDateDeserializer
extends JSR310DateTimeDeserializerBase<LocalDate> {
    private static final long serialVersionUID = 1L;
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    public static final LocalDateDeserializer INSTANCE = new LocalDateDeserializer();

    private LocalDateDeserializer() {
        this(DEFAULT_FORMATTER);
    }

    public LocalDateDeserializer(DateTimeFormatter dtf) {
        super(LocalDate.class, dtf);
    }

    @Override
    protected JsonDeserializer<LocalDate> withDateFormat(DateTimeFormatter dtf) {
        return new LocalDateDeserializer(dtf);
    }

    @Override
    public LocalDate deserialize(JsonParser parser, DeserializationContext context2) throws IOException {
        if (parser.hasToken(JsonToken.VALUE_STRING)) {
            String string2 = parser.getText().trim();
            if (string2.length() == 0) {
                return null;
            }
            DateTimeFormatter format2 = this._formatter;
            try {
                if (format2 == DEFAULT_FORMATTER && string2.length() > 10 && string2.charAt(10) == 'T') {
                    if (string2.endsWith("Z")) {
                        return LocalDateTime.ofInstant(Instant.parse(string2), ZoneOffset.UTC).toLocalDate();
                    }
                    return LocalDate.parse(string2, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                }
                return LocalDate.parse(string2, format2);
            }
            catch (DateTimeException e) {
                this._rethrowDateTimeException(parser, context2, e, string2);
            }
        }
        if (parser.isExpectedStartArrayToken()) {
            if (parser.nextToken() == JsonToken.END_ARRAY) {
                return null;
            }
            int year = parser.getIntValue();
            int month = parser.nextIntValue(-1);
            int day = parser.nextIntValue(-1);
            if (parser.nextToken() != JsonToken.END_ARRAY) {
                throw context2.wrongTokenException(parser, JsonToken.END_ARRAY, "Expected array to end.");
            }
            return LocalDate.of(year, month, day);
        }
        if (parser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (LocalDate)parser.getEmbeddedObject();
        }
        throw context2.wrongTokenException(parser, JsonToken.VALUE_STRING, "Expected array or string.");
    }
}

