/*
 * Decompiled with CFR 0.152.
 */
package firrtl.passes.memlib;

import firrtl.Transform;
import firrtl.Utils$;
import firrtl.annotations.Annotation;
import firrtl.annotations.CircuitName;
import firrtl.annotations.Named;
import firrtl.passes.memlib.InputConfigFileName$;
import firrtl.passes.memlib.OutputConfigFileName$;
import firrtl.passes.memlib.PassCircuitName$;
import firrtl.passes.memlib.PassConfigUtil$;
import firrtl.passes.memlib.PassOption;
import firrtl.passes.memlib.ReplSeqMem;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public final class ReplSeqMemAnnotation$ {
    public static final ReplSeqMemAnnotation$ MODULE$;
    private final Regex matcher;

    static {
        new ReplSeqMemAnnotation$();
    }

    public Annotation apply(String t) {
        String usage2 = "\n[Optional] ReplSeqMem\n  Pass to replace sequential memories with blackboxes + configuration file\n\nUsage: \n  --replSeqMem -c:<circuit>:-i:<filename>:-o:<filename>\n  *** Note: sub-arguments to --replSeqMem should be delimited by : and not white space!\n\nRequired Arguments:\n  -o<filename>         Specify the output configuration file\n  -c<compiler>         Specify the target circuit\n\nOptional Arguments:\n  -i<filename>         Specify the input configuration file (for additional optimizations)\n";
        Map<PassOption, String> passOptions = PassConfigUtil$.MODULE$.getPassOptions(t, usage2);
        String outputConfig = (String)((Object)passOptions.getOrElse(OutputConfigFileName$.MODULE$, new Serializable(usage2){
            public static final long serialVersionUID = 0L;
            private final String usage$2;

            public final Nothing$ apply() {
                return Utils$.MODULE$.error(new StringBuilder().append((Object)"No output config file provided for ReplSeqMem!").append((Object)this.usage$2).toString());
            }
            {
                this.usage$2 = usage$2;
            }
        }));
        String inputFileName = PassConfigUtil$.MODULE$.getPassOptions(t, PassConfigUtil$.MODULE$.getPassOptions$default$2()).getOrElse(InputConfigFileName$.MODULE$, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String passCircuit = (String)((Object)passOptions.getOrElse(PassCircuitName$.MODULE$, new Serializable(usage2){
            public static final long serialVersionUID = 0L;
            private final String usage$2;

            public final Nothing$ apply() {
                return Utils$.MODULE$.error(new StringBuilder().append((Object)"No circuit name specified for ReplSeqMem!").append((Object)this.usage$2).toString());
            }
            {
                this.usage$2 = usage$2;
            }
        }));
        CircuitName target = new CircuitName(passCircuit);
        return new Annotation(target, ReplSeqMem.class, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{inputFileName, outputConfig})));
    }

    public Annotation apply(CircuitName target, String inputFileName, String outputConfig) {
        return new Annotation(target, ReplSeqMem.class, new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{inputFileName, outputConfig})));
    }

    private Regex matcher() {
        return this.matcher;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Option<Tuple3<CircuitName, String, String>> unapply(Annotation a2) {
        void var12_14;
        Annotation annotation = a2;
        if (annotation != null) {
            Named named = annotation.target();
            Class<? extends Transform> t = annotation.transform();
            String string2 = annotation.value();
            if (named instanceof CircuitName) {
                CircuitName circuitName = (CircuitName)named;
                String c = circuitName.name();
                Option<List<String>> option2 = this.matcher().unapplySeq(string2);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String inputFileName = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    String outputConfig = (String)((LinearSeqOptimized)option2.get()).apply(1);
                    Class<? extends Transform> clazz = t;
                    Class<ReplSeqMem> clazz2 = ReplSeqMem.class;
                    if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                        Some<Tuple3<CircuitName, String, String>> some2 = new Some<Tuple3<CircuitName, String, String>>(new Tuple3<CircuitName, String, String>(new CircuitName(c), inputFileName, outputConfig));
                        return var12_14;
                    }
                }
            }
        }
        None$ none$ = None$.MODULE$;
        return var12_14;
    }

    private ReplSeqMemAnnotation$() {
        MODULE$ = this;
        this.matcher = new StringOps(Predef$.MODULE$.augmentString("([^ ]*) ([^ ]+)")).r();
    }
}

