/*
 * Decompiled with CFR 0.152.
 */
package firrtl.util;

import firrtl.transforms.BlackBoxSourceHelper$;
import firrtl.util.BackendCompilationUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.sys.process.Process$;
import scala.sys.process.ProcessBuilder;
import scala.sys.process.ProcessLogger$;

public abstract class BackendCompilationUtilities$class {
    public static File TestDirectory(BackendCompilationUtilities $this) {
        return new File("test_run_dir");
    }

    public static String timeStamp(BackendCompilationUtilities $this) {
        SimpleDateFormat format2 = new SimpleDateFormat("yyyyMMddHHmmss");
        Date now = Calendar.getInstance().getTime();
        return format2.format(now);
    }

    public static void copyResourceToFile(BackendCompilationUtilities $this, String name2, File file) {
        InputStream in = $this.getClass().getResourceAsStream(name2);
        if (in == null) {
            throw new FileNotFoundException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resource '", "'"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2})));
        }
        FileOutputStream out = new FileOutputStream(file);
        package$.MODULE$.Iterator().continually(new Serializable($this, in){
            public static final long serialVersionUID = 0L;
            private final InputStream in$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.in$1.read();
            }
            {
                this.in$1 = in$1;
            }
        }).takeWhile((Function1<Object, Object>)((Object)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return -1 != x$1;
            }
        })).foreach(new Serializable($this, out){
            public static final long serialVersionUID = 0L;
            private final FileOutputStream out$1;

            public final void apply(int x$1) {
                this.apply$mcVI$sp(x$1);
            }

            public void apply$mcVI$sp(int x$1) {
                this.out$1.write(x$1);
            }
            {
                this.out$1 = out$1;
            }
        });
        out.close();
    }

    public static File createTestDirectory(BackendCompilationUtilities $this, String testName) {
        File outer = new File($this.TestDirectory(), testName);
        outer.mkdirs();
        return Files.createTempDirectory(outer.toPath(), $this.timeStamp(), new FileAttribute[0]).toFile();
    }

    public static File makeHarness(BackendCompilationUtilities $this, Function1 template, String post, File f) {
        String prefix = (String)Predef$.MODULE$.refArrayOps((Object[])f.toString().split("/")).last();
        File vf = new File(new StringBuilder().append((Object)f.toString()).append((Object)post).toString());
        FileWriter w = new FileWriter(vf);
        w.write((String)template.apply(prefix));
        w.close();
        return vf;
    }

    public static ProcessBuilder firrtlToVerilog(BackendCompilationUtilities $this, String prefix, File dir) {
        return Process$.MODULE$.apply((Seq<String>)((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"firrtl", "-i", new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".fir"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{prefix})), "-o", new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".v"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{prefix})), "-X", "verilog"}))), dir, Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
    }

    public static ProcessBuilder verilogToCpp(BackendCompilationUtilities $this, String dutFile, File dir, Seq vSources, File cppHarness) {
        String topModule = dutFile;
        File list_file = new File(dir, BlackBoxSourceHelper$.MODULE$.FileListName());
        Seq blackBoxVerilogList = list_file.exists() ? (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-f", list_file.getAbsolutePath()})) : (Seq)Seq$.MODULE$.empty();
        Seq<String> command = ((TraversableLike)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"verilator", "--cc", new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ".v"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{dir.getAbsolutePath(), dutFile}))}))).$plus$plus(blackBoxVerilogList, Seq$.MODULE$.canBuildFrom())).$plus$plus(vSources.flatMap(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(File file) {
                return (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-v", file.getAbsolutePath()}));
            }
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus(Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--assert", "-Wno-fatal", "-Wno-WIDTH", "-Wno-STMTDLY", "--trace", "-O1", "--top-module", topModule, new StringBuilder().append((Object)"+define+TOP_TYPE=V").append((Object)dutFile).toString(), new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+define+PRINTF_COND=!", ".reset"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topModule})), new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"+define+STOP_COND=!", ".reset"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{topModule})), "-CFLAGS", new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-Wno-undefined-bool-conversion -O1 -DTOP_TYPE=V", " -DVL_USER_FINISH -include V", ".h"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{dutFile, dutFile})), "-Mdir", dir.getAbsolutePath(), "--exe", cppHarness.getAbsolutePath()})), Seq$.MODULE$.canBuildFrom());
        System.out.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{command.mkString(" ")})));
        return scala.sys.process.package$.MODULE$.stringSeqToProcess(command);
    }

    public static ProcessBuilder cppToExe(BackendCompilationUtilities $this, String prefix, File dir) {
        return scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"make", "-C", dir.toString(), "-j", "-f", new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"V", ".mk"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{prefix})), new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"V", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{prefix}))})));
    }

    public static boolean executeExpectingFailure(BackendCompilationUtilities $this, String prefix, File dir, String assertionMsg) {
        BooleanRef triggered = BooleanRef.create(false);
        String string2 = assertionMsg;
        String string3 = "";
        boolean assertionMessageSupplied = string2 != null ? !string2.equals(string3) : string3 != null;
        int e = Process$.MODULE$.apply(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"./V", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{prefix})), dir, Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang(ProcessLogger$.MODULE$.apply((Function1<String, BoxedUnit>)((Object)new Serializable($this, triggered, assertionMessageSupplied, assertionMsg){
            public static final long serialVersionUID = 0L;
            private final BooleanRef triggered$1;
            private final boolean assertionMessageSupplied$1;
            private final String assertionMsg$1;

            public final void apply(String line) {
                this.triggered$1.elem = this.triggered$1.elem || this.assertionMessageSupplied$1 && line.contains(this.assertionMsg$1);
                System.out.println(line);
            }
            {
                this.triggered$1 = triggered$1;
                this.assertionMessageSupplied$1 = assertionMessageSupplied$1;
                this.assertionMsg$1 = assertionMsg$1;
            }
        })));
        return triggered.elem || e != 0 && (e != 134 || !assertionMessageSupplied);
    }

    public static String executeExpectingFailure$default$3(BackendCompilationUtilities $this) {
        return "";
    }

    public static boolean executeExpectingSuccess(BackendCompilationUtilities $this, String prefix, File dir) {
        return !$this.executeExpectingFailure(prefix, dir, $this.executeExpectingFailure$default$3());
    }

    public static void $init$(BackendCompilationUtilities $this) {
    }
}

