/*
 * Decompiled with CFR 0.152.
 */
package firrtl_interpreter;

import firrtl.CommonOptions;
import firrtl.ExecutionOptionsManager;
import firrtl.HasCommonOptions;
import firrtl_interpreter.Concrete;
import firrtl_interpreter.Concrete$;
import firrtl_interpreter.ConcreteClock;
import firrtl_interpreter.ConcreteSInt;
import firrtl_interpreter.ConcreteUInt;
import firrtl_interpreter.FirrtlTerp;
import firrtl_interpreter.FirrtlTerp$;
import firrtl_interpreter.HasInterpreterSuite;
import firrtl_interpreter.InterpreterException;
import firrtl_interpreter.InterpreterException$;
import firrtl_interpreter.InterpreterOptions;
import firrtl_interpreter.InterpretiveTester$;
import firrtl_interpreter.Memory;
import firrtl_interpreter.package$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001B\u0001\u0003\u0001\u0015\u0011!#\u00138uKJ\u0004(/\u001a;jm\u0016$Vm\u001d;fe*\t1!\u0001\ngSJ\u0014H\u000f\\0j]R,'\u000f\u001d:fi\u0016\u00148\u0001A\n\u0003\u0001\u0019\u0001\"a\u0002\u0006\u000e\u0003!Q\u0011!C\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017!\u0011a!\u00118z%\u00164\u0007\u0002C\u0007\u0001\u0005\u0003\u0005\u000b\u0011\u0002\b\u0002\u000b%t\u0007/\u001e;\u0011\u0005=\u0011bBA\u0004\u0011\u0013\t\t\u0002\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003'Q\u0011aa\u0015;sS:<'BA\t\t\u0011!1\u0002A!A!\u0002\u00139\u0012AD8qi&|gn]'b]\u0006<WM\u001d\t\u00031ei\u0011AA\u0005\u00035\t\u00111\u0003S1t\u0013:$XM\u001d9sKR,'oU;ji\u0016DQ\u0001\b\u0001\u0005\u0002u\ta\u0001P5oSRtDc\u0001\u0010 AA\u0011\u0001\u0004\u0001\u0005\u0006\u001bm\u0001\rA\u0004\u0005\b-m\u0001\n\u00111\u0001\u0018\u0011\u001d\u0011\u0003\u00011A\u0005\u0002\r\nq\"\u001a=qK\u000e$\u0018\r^5p]NlU\r^\u000b\u0002IA\u0011q!J\u0005\u0003M!\u00111!\u00138u\u0011\u001dA\u0003\u00011A\u0005\u0002%\n1#\u001a=qK\u000e$\u0018\r^5p]NlU\r^0%KF$\"AK\u0017\u0011\u0005\u001dY\u0013B\u0001\u0017\t\u0005\u0011)f.\u001b;\t\u000f9:\u0013\u0011!a\u0001I\u0005\u0019\u0001\u0010J\u0019\t\rA\u0002\u0001\u0015)\u0003%\u0003A)\u0007\u0010]3di\u0006$\u0018n\u001c8t\u001b\u0016$\b\u0005C\u00043\u0001\t\u0007I\u0011A\u001a\u0002\u0017%tG/\u001a:qe\u0016$XM]\u000b\u0002iA\u0011\u0001$N\u0005\u0003m\t\u0011!BR5seRdG+\u001a:q\u0011\u0019A\u0004\u0001)A\u0005i\u0005a\u0011N\u001c;feB\u0014X\r^3sA!9!\b\u0001b\u0001\n\u0003Y\u0014AE5oi\u0016\u0014\bO]3uKJ|\u0005\u000f^5p]N,\u0012\u0001\u0010\t\u00031uJ!A\u0010\u0002\u0003%%sG/\u001a:qe\u0016$XM](qi&|gn\u001d\u0005\u0007\u0001\u0002\u0001\u000b\u0011\u0002\u001f\u0002'%tG/\u001a:qe\u0016$XM](qi&|gn\u001d\u0011\t\u000f\t\u0003!\u0019!C\u0001\u0007\u0006i1m\\7n_:|\u0005\u000f^5p]N,\u0012\u0001\u0012\t\u0003\u000b\"k\u0011A\u0012\u0006\u0002\u000f\u00061a-\u001b:si2L!!\u0013$\u0003\u001b\r{W.\\8o\u001fB$\u0018n\u001c8t\u0011\u0019Y\u0005\u0001)A\u0005\t\u0006q1m\\7n_:|\u0005\u000f^5p]N\u0004\u0003\"B'\u0001\t\u0003q\u0015AC:fiZ+'OY8tKR\u0011!f\u0014\u0005\b!2\u0003\n\u00111\u0001R\u0003\u00151\u0018\r\\;f!\t9!+\u0003\u0002T\u0011\t9!i\\8mK\u0006t\u0007bB+\u0001\u0005\u0004%\tAV\u0001\ngR\f'\u000f\u001e+j[\u0016,\u0012a\u0016\t\u0003\u000faK!!\u0017\u0005\u0003\t1{gn\u001a\u0005\u00077\u0002\u0001\u000b\u0011B,\u0002\u0015M$\u0018M\u001d;US6,\u0007\u0005C\u0004^\u0001\u0001\u0007I\u0011\u0002,\u0002\u0017\u0019\f\u0017\u000e\\;sKRKW.\u001a\u0005\b?\u0002\u0001\r\u0011\"\u0003a\u0003=1\u0017-\u001b7ve\u0016$\u0016.\\3`I\u0015\fHC\u0001\u0016b\u0011\u001dqc,!AA\u0002]Caa\u0019\u0001!B\u00139\u0016\u0001\u00044bS2,(/\u001a+j[\u0016\u0004\u0003bB3\u0001\u0001\u0004%IAZ\u0001\tM\u0006LGnQ8eKV\tq\rE\u0002\bQ\u0012J!!\u001b\u0005\u0003\r=\u0003H/[8o\u0011\u001dY\u0007\u00011A\u0005\n1\fABZ1jY\u000e{G-Z0%KF$\"AK7\t\u000f9R\u0017\u0011!a\u0001O\"1q\u000e\u0001Q!\n\u001d\f\u0011BZ1jY\u000e{G-\u001a\u0011\t\u000bE\u0004A\u0011\u0001:\u0002\t\u0019\f\u0017\u000e\u001c\u000b\u0003UMDQ\u0001\u001e9A\u0002\u0011\nAaY8eK\")\u0011\u000f\u0001C\u0001mR!qO_A\t!\t9\u00010\u0003\u0002z\u0011\t9aj\u001c;iS:<\u0007\"B>v\u0001\u0004a\u0018AA3y!\ri\u00181\u0002\b\u0004}\u0006\u001dabA@\u0002\u00065\u0011\u0011\u0011\u0001\u0006\u0004\u0003\u0007!\u0011A\u0002\u001fs_>$h(C\u0001\n\u0013\r\tI\u0001C\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti!a\u0004\u0003\u0013QC'o\\<bE2,'bAA\u0005\u0011!I\u00111C;\u0011\u0002\u0003\u0007\u0011QC\u0001\u0004[N<\u0007cA\u0004i\u001d!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0011\u0001B5t\u001f.+\u0012!\u0015\u0005\b\u0003?\u0001A\u0011AA\u0011\u0003\u0011\u0001xn[3\u0015\u000b)\n\u0019#a\n\t\u000f\u0005\u0015\u0012Q\u0004a\u0001\u001d\u0005!a.Y7f\u0011\u001d\u0001\u0016Q\u0004a\u0001\u0003S\u00012!`A\u0016\u0013\u0011\ti#a\u0004\u0003\r\tKw-\u00138u\u0011\u001d\ty\u0002\u0001C\u0001\u0003c!RAKA\u001a\u0003kAq!!\n\u00020\u0001\u0007a\u0002C\u0004Q\u0003_\u0001\r!a\u000e\u0011\u0007a\tI$C\u0002\u0002<\t\u0011\u0001bQ8oGJ,G/\u001a\u0005\b\u0003\u007f\u0001A\u0011AA!\u0003)\u0001xn[3NK6|'/\u001f\u000b\bU\u0005\r\u0013QIA%\u0011\u001d\t)#!\u0010A\u00029Aq!a\u0012\u0002>\u0001\u0007A%A\u0003j]\u0012,\u0007\u0010C\u0004Q\u0003{\u0001\r!!\u000b\t\u000f\u00055\u0003\u0001\"\u0001\u0002P\u0005!\u0001/Z3l)\u0011\tI#!\u0015\t\u000f\u0005\u0015\u00121\na\u0001\u001d!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0013A\u00039fK.lU-\\8ssR1\u0011\u0011FA-\u00037Bq!!\n\u0002T\u0001\u0007a\u0002C\u0004\u0002H\u0005M\u0003\u0019\u0001\u0013\t\u000f\u0005}\u0003\u0001\"\u0001\u0002b\u0005a\u0001/Z3l\u0007>t7M]3uKR!\u0011qGA2\u0011\u001d\t)#!\u0018A\u00029Aq!a\u001a\u0001\t\u0003\tI'\u0001\u0004fqB,7\r\u001e\u000b\u0006U\u0005-\u0014Q\u000e\u0005\b\u0003K\t)\u00071\u0001\u000f\u0011!\ty'!\u001aA\u0002\u0005%\u0012!D3ya\u0016\u001cG/\u001a3WC2,X\rC\u0004\u0002t\u0001!\t!!\u001e\u0002\tM$X\r\u001d\u000b\u0004U\u0005]\u0004\"CA=\u0003c\u0002\n\u00111\u0001%\u0003\u0005q\u0007bBA?\u0001\u0011\u0005\u0011qP\u0001\re\u0016\u0004xN\u001d;TiJLgnZ\u000b\u0002\u001d!9\u00111\u0011\u0001\u0005\u0002\u0005\u0015\u0015A\u0002:fa>\u0014H\u000fF\u0001+\u0011\u001d\tI\t\u0001C\u0001\u00037\taAZ5oSND\u0007\"CAG\u0001E\u0005I\u0011AAH\u0003Q\u0019X\r\u001e,fe\n|7/\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0013\u0016\u0004#\u0006M5FAAK!\u0011\t9*!)\u000e\u0005\u0005e%\u0002BAN\u0003;\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}\u0005\"\u0001\u0006b]:|G/\u0019;j_:LA!a)\u0002\u001a\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005\u001d\u0006!%A\u0005\u0002\u0005%\u0016A\u00044bS2$C-\u001a4bk2$HEM\u000b\u0003\u0003WSC!!\u0006\u0002\u0014\"I\u0011q\u0016\u0001\u0012\u0002\u0013\u0005\u0011\u0011W\u0001\u000fgR,\u0007\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019LK\u0002%\u0003';\u0011\"a.\u0003\u0003\u0003E\t!!/\u0002%%sG/\u001a:qe\u0016$\u0018N^3UKN$XM\u001d\t\u00041\u0005mf\u0001C\u0001\u0003\u0003\u0003E\t!!0\u0014\u0007\u0005mf\u0001C\u0004\u001d\u0003w#\t!!1\u0015\u0005\u0005e\u0006BCAc\u0003w\u000b\n\u0011\"\u0001\u0002H\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!!3+\u0007]\t\u0019\n")
public class InterpretiveTester {
    private int expectationsMet = 0;
    private final FirrtlTerp interpreter;
    private final InterpreterOptions interpreterOptions;
    private final CommonOptions commonOptions;
    private final long startTime;
    private long failureTime;
    private Option<Object> failCode;

    public static HasInterpreterSuite $lessinit$greater$default$2() {
        return InterpretiveTester$.MODULE$.$lessinit$greater$default$2();
    }

    public int expectationsMet() {
        return this.expectationsMet;
    }

    public void expectationsMet_$eq(int x$1) {
        this.expectationsMet = x$1;
    }

    public FirrtlTerp interpreter() {
        return this.interpreter;
    }

    public InterpreterOptions interpreterOptions() {
        return this.interpreterOptions;
    }

    public CommonOptions commonOptions() {
        return this.commonOptions;
    }

    public void setVerbose(boolean value2) {
        this.interpreter().setVerbose(value2);
    }

    public boolean setVerbose$default$1() {
        return true;
    }

    public long startTime() {
        return this.startTime;
    }

    private long failureTime() {
        return this.failureTime;
    }

    private void failureTime_$eq(long x$1) {
        this.failureTime = x$1;
    }

    private Option<Object> failCode() {
        return this.failCode;
    }

    private void failCode_$eq(Option<Object> x$1) {
        this.failCode = x$1;
    }

    public void fail(int code) {
        this.interpreter().circuitState().writeVCD();
        if (this.failCode().isEmpty()) {
            this.failureTime_$eq(System.nanoTime());
            this.failCode_$eq(new Some<Object>(BoxesRunTime.boxToInteger(code)));
        }
    }

    public Nothing$ fail(Throwable ex, Option<String> msg) {
        Option<String> option2 = msg;
        if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            String s2 = (String)some2.x();
            Predef$.MODULE$.println(s2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.fail(2);
        throw ex;
    }

    public Option<String> fail$default$2() {
        return None$.MODULE$;
    }

    public boolean isOK() {
        Some some2;
        int n;
        Option<Object> option2 = this.failCode();
        boolean bl = None$.MODULE$.equals(option2) ? true : option2 instanceof Some && 0 == (n = BoxesRunTime.unboxToInt((some2 = (Some)option2).x()));
        boolean bl2 = bl;
        return bl2;
    }

    public void poke(String name2, BigInt value2) {
        if (this.interpreter().checkStopped(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"poke(", ", ", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2, value2})))) {
            return;
        }
        try {
            boolean isRegister = this.interpreter().circuitState().registers().contains(name2);
            this.interpreter().circuitState().vcdLowerClock();
            String x$1 = name2;
            BigInt x$2 = value2;
            boolean x$3 = isRegister;
            boolean x$4 = this.interpreter().setValueWithBigInt$default$3();
            this.interpreter().setValueWithBigInt(x$1, x$2, x$4, x$3);
            return;
        }
        catch (InterpreterException interpreterException) {
            throw this.fail(interpreterException, new Some<String>(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: poke(", ", ", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2, value2}))));
        }
    }

    public void poke(String name2, Concrete value2) {
        if (this.interpreter().checkStopped(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"poke(", ", ", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2, value2})))) {
            return;
        }
        try {
            boolean isRegister = this.interpreter().circuitState().registers().contains(name2);
            this.interpreter().circuitState().vcdLowerClock();
            this.interpreter().circuitState().setValue(name2, value2, isRegister);
            return;
        }
        catch (InterpreterException interpreterException) {
            throw this.fail(interpreterException, new Some<String>(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: poke(", ", ", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2, value2}))));
        }
    }

    public void pokeMemory(String name2, int index2, BigInt value2) {
        if (this.interpreter().checkStopped(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pokeMemory(", ", ", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2, value2})))) {
            return;
        }
        Option option2 = this.interpreter().circuitState().memories().get(name2);
        if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            Memory memory = (Memory)some2.x();
            memory.forceWrite(index2, value2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw InterpreterException$.MODULE$.apply(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: memory ", ".forceWrite(", ", ", "). memory not found"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2, BoxesRunTime.boxToInteger(index2), value2})));
    }

    public BigInt peek(String name2) {
        block6: {
            BigInt bigInt2;
            block5: {
                BigInt value2;
                Concrete concrete;
                block4: {
                    BigInt value3;
                    if (this.interpreter().checkStopped(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"peek(", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2})))) {
                        return BigInt$.MODULE$.int2bigInt(0);
                    }
                    concrete = this.interpreter().getValue(name2);
                    if (!(concrete instanceof ConcreteUInt)) break block4;
                    ConcreteUInt concreteUInt = (ConcreteUInt)concrete;
                    bigInt2 = value3 = concreteUInt.value();
                    break block5;
                }
                if (!(concrete instanceof ConcreteSInt)) break block6;
                ConcreteSInt concreteSInt = (ConcreteSInt)concrete;
                bigInt2 = value2 = concreteSInt.value();
            }
            return bigInt2;
        }
        throw this.fail(new InterpreterException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error:peek(", ") value not found"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2}))), this.fail$default$2());
    }

    public BigInt peekMemory(String name2, int index2) {
        return this.interpreter().getMemory(name2, index2);
    }

    public Concrete peekConcrete(String name2) {
        if (this.interpreter().checkStopped(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"peekConcrete(", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2})))) {
            return Concrete$.MODULE$.poisonedUInt(1);
        }
        Concrete concrete = this.interpreter().getValue(name2);
        if (concrete != null) {
            Concrete concrete2;
            Concrete concrete3 = concrete2 = concrete;
            return concrete3;
        }
        throw this.fail(new InterpreterException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error:peek(", ") value not found"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2}))), this.fail$default$2());
    }

    public void expect(String name2, BigInt expectedValue) {
        block7: {
            block5: {
                Concrete concrete;
                block6: {
                    block4: {
                        if (this.interpreter().checkStopped(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect(", ", ", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2, expectedValue})))) {
                            return;
                        }
                        concrete = this.interpreter().getValue(name2);
                        if (!(concrete instanceof ConcreteUInt)) break block4;
                        ConcreteUInt concreteUInt = (ConcreteUInt)concrete;
                        this.testValue$1(concreteUInt, name2, expectedValue);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block5;
                    }
                    if (!(concrete instanceof ConcreteSInt)) break block6;
                    ConcreteSInt concreteSInt = (ConcreteSInt)concrete;
                    this.testValue$1(concreteSInt, name2, expectedValue);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (!(concrete instanceof ConcreteClock)) break block7;
                ConcreteClock concreteClock = (ConcreteClock)concrete;
                this.testValue$1(concreteClock, name2, expectedValue);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.expectationsMet_$eq(this.expectationsMet() + 1);
            return;
        }
        throw this.fail(new InterpreterException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error:expect(", ", ", ") value not found"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name2, expectedValue}))), this.fail$default$2());
    }

    public void step(int n) {
        if (this.interpreter().checkStopped(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"step(", ")"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(n)})))) {
            return;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InterpretiveTester $outer;

            public final void apply(int _) {
                this.apply$mcVI$sp(_);
            }

            public void apply$mcVI$sp(int _) {
                this.$outer.interpreter().cycle(this.$outer.interpreter().cycle$default$1());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public int step$default$1() {
        return 1;
    }

    public String reportString() {
        long endTime = System.nanoTime();
        double elapsedSeconds = (double)(endTime - this.startTime()) / 1.0E9;
        double arg$macro$17 = elapsedSeconds;
        return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test ", " "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.interpreter().loweredAst().main()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", " tests passed "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.status$1(), BoxesRunTime.boxToInteger(this.expectationsMet())}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in ", " cycles "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.interpreter().circuitState().stateCounter())}))).append((Object)new StringOps("taking %.6f seconds").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(arg$macro$17)}))).toString();
    }

    public void report() {
        this.interpreter().writeVCD();
        Predef$.MODULE$.println(this.reportString());
    }

    public boolean finish() {
        return this.isOK();
    }

    private final void testValue$1(Concrete concrete, String name$1, BigInt expectedValue$1) {
        BigInt bigInt2 = concrete.value();
        BigInt bigInt3 = expectedValue$1;
        if (!(bigInt2 != null ? !((Object)bigInt2).equals(bigInt3) : bigInt3 != null)) {
            return;
        }
        if (!this.interpreter().verbose()) {
            this.interpreter().reEvaluate(name$1);
        }
        throw this.fail(new InterpreterException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error:expect(", ", ", ") got ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{name$1, expectedValue$1, concrete.showValue()}))), this.fail$default$2());
    }

    private final String status$1() {
        String string2;
        Option<Object> option2 = this.interpreter().lastStopResult();
        if (option2 instanceof Some) {
            Some some2 = (Some)option2;
            int stopResult = BoxesRunTime.unboxToInt(some2.x());
            string2 = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed: Stop result ", ":"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(stopResult)}));
        } else {
            string2 = this.isOK() ? new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Success:"})).s(Nil$.MODULE$) : new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed: Code ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.failCode().get()}));
        }
        return string2;
    }

    public InterpretiveTester(String input2, HasInterpreterSuite optionsManager2) {
        package$.MODULE$.random().setSeed(optionsManager2.interpreterOptions().randomSeed());
        this.interpreter = FirrtlTerp$.MODULE$.apply(input2, optionsManager2);
        this.interpreterOptions = optionsManager2.interpreterOptions();
        this.commonOptions = ((HasCommonOptions)((Object)optionsManager2)).commonOptions();
        this.interpreter().evaluator().allowCombinationalLoops_$eq(this.interpreterOptions().allowCycles());
        this.interpreter().evaluator().useTopologicalSortedKeys_$eq(this.interpreterOptions().setOrderedExec());
        this.interpreter().evaluator().evaluationStack().maxExecutionDepth_$eq(this.interpreterOptions().maxExecutionDepth());
        this.interpreter().setVerbose(this.interpreterOptions().setVerbose());
        this.setVerbose(this.interpreterOptions().setVerbose());
        if (this.interpreterOptions().writeVCD()) {
            ((ExecutionOptionsManager)((Object)optionsManager2)).setTopNameIfNotSet(this.interpreter().loweredAst().main());
            ((ExecutionOptionsManager)((Object)optionsManager2)).makeTargetDir();
            this.interpreter().makeVCDLogger(this.interpreterOptions().vcdOutputFileName((ExecutionOptionsManager)((Object)optionsManager2)), this.interpreterOptions().vcdShowUnderscored());
        }
        this.startTime = System.nanoTime();
        this.failureTime = -1L;
        this.failCode = None$.MODULE$;
    }
}

