/*
 * Decompiled with CFR 0.152.
 */
package firrtl_interpreter.vcd;

import firrtl_interpreter.vcd.Change;
import firrtl_interpreter.vcd.Scope;
import firrtl_interpreter.vcd.Scope$;
import firrtl_interpreter.vcd.VCD;
import firrtl_interpreter.vcd.VCDConfig;
import firrtl_interpreter.vcd.VCDOptionsManager;
import firrtl_interpreter.vcd.Wire;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import logger.LazyLogging;
import logger.LazyLogging$class;
import logger.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.matching.Regex;

public final class VCD$
implements LazyLogging,
Serializable {
    public static final VCD$ MODULE$;
    private final String Version;
    private final String DateDeclaration;
    private final String VersionDeclaration;
    private final String CommentDeclaration;
    private final String TimeScaleDeclaration;
    private final String ScopeDeclaration;
    private final String VarDeclaration;
    private final String UpScopeDeclaration;
    private final String EndDefinitionsDeclaration;
    private final String DumpVarsDeclaration;
    private final String End;
    private final String firrtl_interpreter$vcd$VCD$$ClockName;
    private final String ResetName;
    private final Seq<String> idChars;
    private final int numberOfIdChars;
    private final Regex SectionHeader;
    private final Regex EndSection;
    private final Regex ScopedModule;
    private final Regex JustScoped;
    private final Regex VarSpec;
    private final Regex ValueChangeScalar;
    private final Regex ValueChangeVector;
    private final Regex ValueChangeVectorX;
    private final Regex TimeStamp;
    private final Logger logger;

    static {
        new VCD$();
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void logger$LazyLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String Version() {
        return this.Version;
    }

    public String DateDeclaration() {
        return this.DateDeclaration;
    }

    public String VersionDeclaration() {
        return this.VersionDeclaration;
    }

    public String CommentDeclaration() {
        return this.CommentDeclaration;
    }

    public String TimeScaleDeclaration() {
        return this.TimeScaleDeclaration;
    }

    public String ScopeDeclaration() {
        return this.ScopeDeclaration;
    }

    public String VarDeclaration() {
        return this.VarDeclaration;
    }

    public String UpScopeDeclaration() {
        return this.UpScopeDeclaration;
    }

    public String EndDefinitionsDeclaration() {
        return this.EndDefinitionsDeclaration;
    }

    public String DumpVarsDeclaration() {
        return this.DumpVarsDeclaration;
    }

    public String End() {
        return this.End;
    }

    public String firrtl_interpreter$vcd$VCD$$ClockName() {
        return this.firrtl_interpreter$vcd$VCD$$ClockName;
    }

    private String ResetName() {
        return this.ResetName;
    }

    public Seq<String> idChars() {
        return this.idChars;
    }

    public int numberOfIdChars() {
        return this.numberOfIdChars;
    }

    public Regex SectionHeader() {
        return this.SectionHeader;
    }

    public Regex EndSection() {
        return this.EndSection;
    }

    public Regex ScopedModule() {
        return this.ScopedModule;
    }

    public Regex JustScoped() {
        return this.JustScoped;
    }

    public Regex VarSpec() {
        return this.VarSpec;
    }

    public Regex ValueChangeScalar() {
        return this.ValueChangeScalar;
    }

    public Regex ValueChangeVector() {
        return this.ValueChangeVector;
    }

    public Regex ValueChangeVectorX() {
        return this.ValueChangeVectorX;
    }

    public Regex TimeStamp() {
        return this.TimeStamp;
    }

    public VCD apply(String moduleName, String timeScale, String comment2) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
        df.setTimeZone(tz);
        String nowAsISO = df.format(new Date());
        return new VCD(nowAsISO, this.Version(), comment2, timeScale, moduleName, true);
    }

    public String apply$default$2() {
        return "1ps";
    }

    public String apply$default$3() {
        return "";
    }

    public VCD read(String vcdFile, String startScope, String renameStartScope, String varPrefix, String newVarPrefix) {
        Option option2;
        block6: {
            VCD vcd;
            block5: {
                block4: {
                    VCD.WordIterator words = new VCD.WordIterator(vcdFile);
                    StringBuilder dateHeader = new StringBuilder();
                    StringBuilder versionHeader = new StringBuilder();
                    StringBuilder commentHeader = new StringBuilder();
                    StringBuilder timeScaleHeader = new StringBuilder();
                    StringBuilder scopeBuffer = new StringBuilder();
                    StringBuilder endDefinition = new StringBuilder();
                    StringBuilder currentVar = new StringBuilder();
                    ObjectRef<None$> scopeRoot = ObjectRef.create(None$.MODULE$);
                    ObjectRef<None$> currentScope = ObjectRef.create(None$.MODULE$);
                    BooleanRef desiredScopeFound = BooleanRef.create(false);
                    Map supportedVectorRadix = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("b"), BoxesRunTime.boxToInteger(2)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("o"), BoxesRunTime.boxToInteger(8)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("h"), BoxesRunTime.boxToInteger(16))}));
                    HashMap wires = new HashMap();
                    HashMap<String, HashSet<Wire>> aliasedWires = new HashMap<String, HashSet<Wire>>(){

                        public HashSet<Wire> default(String key2) {
                            this.update(key2, new HashSet<A>());
                            return (HashSet)this.apply(key2);
                        }
                    };
                    HashMap skippedWires = new HashMap();
                    LongRef currentTime = LongRef.create(-1L);
                    HashMap<Object, HashSet<Change>> valuesAtTime = new HashMap<Object, HashSet<Change>>(){

                        public HashSet<Change> default(long key2) {
                            this.update(BoxesRunTime.boxToLong(key2), new HashSet<A>());
                            return (HashSet)this.apply(BoxesRunTime.boxToLong(key2));
                        }
                    };
                    HashSet initialValues = new HashSet();
                    this.processSections$1(startScope, renameStartScope, varPrefix, newVarPrefix, words, dateHeader, versionHeader, commentHeader, timeScaleHeader, scopeBuffer, endDefinition, currentVar, scopeRoot, currentScope, desiredScopeFound, supportedVectorRadix, wires, aliasedWires, skippedWires, currentTime, valuesAtTime, initialValues);
                    if (((Option)scopeRoot.elem).isEmpty()) {
                        this.logger().error((Function0<String>)((Object)new Serializable(startScope){
                            public static final long serialVersionUID = 0L;
                            private final String startScope$1;

                            public final String apply() {
                                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: No start scope found, desired StartScope is ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.startScope$1}));
                            }
                            {
                                this.startScope$1 = startScope$1;
                            }
                        }));
                    }
                    vcd = new VCD(dateHeader.toString().trim(), versionHeader.toString().trim(), commentHeader.toString().trim(), timeScaleHeader.toString().trim(), "", true);
                    vcd.wires().$plus$plus$eq(wires);
                    vcd.initialValues().$plus$plus$eq(initialValues);
                    vcd.valuesAtTime().$plus$plus$eq((TraversableOnce<Tuple2<Object, HashSet<Change>>>)valuesAtTime);
                    vcd.aliasedWires_$eq(aliasedWires);
                    option2 = (Option)scopeRoot.elem;
                    if (!(option2 instanceof Some)) break block4;
                    Some some2 = (Some)option2;
                    Scope scope = (Scope)some2.x();
                    vcd.scopeRoot_$eq(scope);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (!None$.MODULE$.equals(option2)) break block6;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return vcd;
        }
        throw new MatchError(option2);
    }

    public String read$default$2() {
        return "";
    }

    public String read$default$3() {
        return "";
    }

    public String read$default$4() {
        return "";
    }

    public String read$default$5() {
        return "";
    }

    public void main(String[] args) {
        VCDOptionsManager manager = new VCDOptionsManager();
        if (manager.parse(args)) {
            VCDConfig config = manager.vcdConfig();
            VCD vcd = this.read(config.vcdSourceName(), config.startScope(), config.renameStartScope(), config.varPrefix(), config.newVarPrefix());
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{vcd.info()})));
            if (new StringOps(Predef$.MODULE$.augmentString(config.vcdTargetName())).nonEmpty()) {
                vcd.write(config.vcdTargetName());
            }
        } else {
            manager.parser().showUsageAsError();
        }
    }

    public VCD apply(String date, String version2, String comment2, String timeScale, String scope, boolean ignoreUnderscoredNames) {
        return new VCD(date, version2, comment2, timeScale, scope, ignoreUnderscoredNames);
    }

    public Option<Tuple6<String, String, String, String, String, Object>> unapply(VCD x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple6<String, String, String, String, String, Boolean>>(new Tuple6<String, String, String, String, String, Boolean>(x$0.date(), x$0.version(), x$0.comment(), x$0.timeScale(), x$0.scope(), BoxesRunTime.boxToBoolean(x$0.ignoreUnderscoredNames())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    private final void addScope$1(String name, String startScope$1, String renameStartScope$1, ObjectRef scopeRoot$1, ObjectRef currentScope$1, BooleanRef desiredScopeFound$1) {
        block3: {
            block2: {
                var7_7 = (Option)currentScope$1.elem;
                if (!(var7_7 instanceof Some)) break block2;
                var8_8 = (Some)var7_7;
                scope = (Scope)var8_8.x();
                currentScope$1.elem = new Some<Scope>(new Scope(name, (Option)currentScope$1.elem));
                scope.subScopes().$plus$eq(((Option)currentScope$1.elem).get());
                var10_10 = BoxedUnit.UNIT;
                break block3;
            }
            if (startScope$1.isEmpty()) ** GOTO lbl-1000
            v0 = name;
            var11_12 = startScope$1;
            if (!(v0 != null ? v0.equals(var11_12) == false : var11_12 != null)) lbl-1000:
            // 2 sources

            {
                newName = renameStartScope$1.isEmpty() != false ? name : renameStartScope$1;
                scopeRoot$1.elem = new Some<Scope>(new Scope(newName, Scope$.MODULE$.apply$default$2()));
                currentScope$1.elem = (Option)scopeRoot$1.elem;
                desiredScopeFound$1.elem = true;
                v1 = BoxedUnit.UNIT;
            } else {
                v1 = BoxedUnit.UNIT;
            }
            var10_11 = v1;
        }
    }

    private final void processScope$1(String startScope$1, String renameStartScope$1, VCD.WordIterator words$1, StringBuilder scopeBuffer$1, ObjectRef scopeRoot$1, ObjectRef currentScope$1, BooleanRef desiredScopeFound$1) {
        block5: {
            BoxedUnit boxedUnit;
            while (words$1.hasNext()) {
                String string2 = words$1.next();
                Option<List<String>> option2 = this.EndSection().unapplySeq(string2);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0) {
                    String string3 = scopeBuffer$1.toString();
                    Option<List<String>> option3 = this.ScopedModule().unapplySeq(string3);
                    if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                        String kind = (String)((LinearSeqOptimized)option3.get()).apply(0);
                        String moduleName = (String)((LinearSeqOptimized)option3.get()).apply(1);
                        String string4 = kind;
                        String string5 = "module";
                        if (string4 == null ? string5 != null : !string4.equals(string5)) {
                            this.logger().debug((Function0<String>)((Object)new Serializable(words$1, scopeBuffer$1){
                                public static final long serialVersionUID = 0L;
                                private final VCD.WordIterator words$1;
                                private final StringBuilder scopeBuffer$1;

                                public final String apply() {
                                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unsupported scope type ", " at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.scopeBuffer$1.toString(), BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}));
                                }
                                {
                                    this.words$1 = words$1;
                                    this.scopeBuffer$1 = scopeBuffer$1;
                                }
                            }));
                        }
                        this.addScope$1(moduleName, startScope$1, renameStartScope$1, scopeRoot$1, currentScope$1, desiredScopeFound$1);
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        this.logger().warn((Function0<String>)((Object)new Serializable(words$1, scopeBuffer$1){
                            public static final long serialVersionUID = 0L;
                            private final VCD.WordIterator words$1;
                            private final StringBuilder scopeBuffer$1;

                            public final String apply() {
                                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unknown scope format ", " at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.scopeBuffer$1.toString(), BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}));
                            }
                            {
                                this.words$1 = words$1;
                                this.scopeBuffer$1 = scopeBuffer$1;
                            }
                        }));
                        BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                    }
                    scopeBuffer$1.clear();
                    BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                    boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                scopeBuffer$1.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{string2})));
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void processUpScope$1(String startScope$1, String renameStartScope$1, VCD.WordIterator words$1, StringBuilder scopeBuffer$1, ObjectRef scopeRoot$1, ObjectRef currentScope$1, BooleanRef desiredScopeFound$1) {
        if (!words$1.hasNext()) return;
        String string2 = words$1.next();
        Option<List<String>> option2 = this.EndSection().unapplySeq(string2);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0) {
            void var14_15;
            Option option3 = (Option)currentScope$1.elem;
            if (option3 instanceof Some) {
                Some some2 = (Some)option3;
                Scope scope = (Scope)some2.x();
                Option<Scope> option4 = scope.parent();
            } else {
                if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                desiredScopeFound$1.elem = false;
                None$ none$ = None$.MODULE$;
            }
            currentScope$1.elem = var14_15;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            this.processScope$1(startScope$1, renameStartScope$1, words$1, scopeBuffer$1, scopeRoot$1, currentScope$1, desiredScopeFound$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public final String firrtl_interpreter$vcd$VCD$$scopePathString$1(Option scopeOption, String path) {
        Option option2;
        block4: {
            String string2;
            block3: {
                block2: {
                    option2 = scopeOption;
                    if (!(option2 instanceof Some)) break block2;
                    Some some2 = (Some)option2;
                    Scope scope = (Scope)some2.x();
                    string2 = new StringBuilder().append((Object)this.firrtl_interpreter$vcd$VCD$$scopePathString$1(scope.parent(), this.firrtl_interpreter$vcd$VCD$$scopePathString$default$2$1())).append((Object)scope.name()).append((Object)".").toString();
                    break block3;
                }
                if (!None$.MODULE$.equals(option2)) break block4;
                string2 = "";
            }
            return string2;
        }
        throw new MatchError(option2);
    }

    private final List walkPath$1(Option scopeOption) {
        Option option2;
        block4: {
            List list2;
            block3: {
                block2: {
                    option2 = scopeOption;
                    if (!(option2 instanceof Some)) break block2;
                    Some some2 = (Some)option2;
                    Scope scope = (Scope)some2.x();
                    String string2 = scope.name();
                    list2 = this.walkPath$1(scope.parent()).$colon$colon(string2);
                    break block3;
                }
                if (!None$.MODULE$.equals(option2)) break block4;
                list2 = Nil$.MODULE$;
            }
            return list2;
        }
        throw new MatchError(option2);
    }

    private final List scopePath$1(Option scopeOption) {
        Object object;
        block4: {
            List list2;
            block3: {
                block2: {
                    object = this.walkPath$1(scopeOption).reverse();
                    if (!((Object)Nil$.MODULE$).equals(object)) break block2;
                    list2 = Nil$.MODULE$;
                    break block3;
                }
                if (!(object instanceof $colon$colon)) break block4;
                $colon$colon $colon$colon = ($colon$colon)object;
                List tail2 = $colon$colon.tl$1();
                list2 = tail2;
            }
            return list2;
        }
        throw new MatchError(object);
    }

    public final String firrtl_interpreter$vcd$VCD$$scopePathString$default$2$1() {
        return "";
    }

    private final Option checkName$1(String name2, String varPrefix$1, String newVarPrefix$1) {
        Option option2;
        String string2 = name2;
        String string3 = this.firrtl_interpreter$vcd$VCD$$ClockName();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            option2 = new Some<String>(name2);
        } else {
            String string4 = name2;
            String string5 = this.ResetName();
            option2 = !(string4 != null ? !string4.equals(string5) : string5 != null) ? new Some<String>(name2) : (name2.startsWith(varPrefix$1) ? (new StringOps(Predef$.MODULE$.augmentString(newVarPrefix$1)).nonEmpty() ? new Some<String>(new StringBuilder().append((Object)newVarPrefix$1).append(new StringOps(Predef$.MODULE$.augmentString(name2)).drop(varPrefix$1.length())).toString()) : new Some<String>(name2)) : None$.MODULE$);
        }
        return option2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void addVar$1(String s2, String varPrefix$1, String newVarPrefix$1, VCD.WordIterator words$1, ObjectRef currentScope$1, BooleanRef desiredScopeFound$1, HashMap wires$1, HashMap aliasedWires$1, HashMap skippedWires$1) {
        String string2 = s2;
        Option<List<String>> option2 = this.VarSpec().unapplySeq(string2);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(4) == 0) {
            String string3 = (String)((LinearSeqOptimized)option2.get()).apply(0);
            String sizeString = (String)((LinearSeqOptimized)option2.get()).apply(1);
            String idString = (String)((LinearSeqOptimized)option2.get()).apply(2);
            String referenceString = (String)((LinearSeqOptimized)option2.get()).apply(3);
            if ("wire".equals(string3)) {
                Option option3 = this.checkName$1((String)Predef$.MODULE$.refArrayOps((Object[])referenceString.split(" +")).head(), varPrefix$1, newVarPrefix$1);
                if (option3 instanceof Some) {
                    BoxedUnit boxedUnit;
                    Some some2 = (Some)option3;
                    String varName = (String)some2.x();
                    if (desiredScopeFound$1.elem) {
                        Wire wire2 = new Wire(varName, idString, new StringOps(Predef$.MODULE$.augmentString(sizeString)).toInt(), (String[])this.scopePath$1((Option)currentScope$1.elem).toArray(ClassTag$.MODULE$.apply(String.class)));
                        if (wires$1.contains(idString)) {
                            this.logger().debug((Function0<String>)((Object)new Serializable(words$1, wire2){
                                public static final long serialVersionUID = 0L;
                                private final VCD.WordIterator words$1;
                                private final Wire wire$1;

                                public final String apply() {
                                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AddVar aliased wire ", " at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.wire$1, BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}));
                                }
                                {
                                    this.words$1 = words$1;
                                    this.wire$1 = wire$1;
                                }
                            }));
                            ((HashSet)aliasedWires$1.apply(idString)).$plus$eq(wire2);
                            ((Option)currentScope$1.elem).foreach(new Serializable(wire2){
                                public static final long serialVersionUID = 0L;
                                private final Wire wire$1;

                                public final ArrayBuffer<Wire> apply(Scope x$3) {
                                    return x$3.wires().$plus$eq((Object)this.wire$1);
                                }
                                {
                                    this.wire$1 = wire$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            wires$1.update(idString, wire2);
                            this.logger().debug((Function0<String>)((Object)new Serializable(words$1, wire2){
                                public static final long serialVersionUID = 0L;
                                private final VCD.WordIterator words$1;
                                private final Wire wire$1;

                                public final String apply() {
                                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"AddVar ", " at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.wire$1, BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}));
                                }
                                {
                                    this.words$1 = words$1;
                                    this.wire$1 = wire$1;
                                }
                            }));
                            ((Option)currentScope$1.elem).foreach(new Serializable(wire2){
                                public static final long serialVersionUID = 0L;
                                private final Wire wire$1;

                                public final ArrayBuffer<Wire> apply(Scope x$2) {
                                    return x$2.wires().$plus$eq((Object)this.wire$1);
                                }
                                {
                                    this.wire$1 = wire$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        this.logger().debug((Function0<String>)((Object)new Serializable(words$1, currentScope$1, varName){
                            public static final long serialVersionUID = 0L;
                            private final VCD.WordIterator words$1;
                            private final ObjectRef currentScope$1;
                            private final String varName$1;

                            public final String apply() {
                                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignore var ", "", " at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{VCD$.MODULE$.firrtl_interpreter$vcd$VCD$$scopePathString$1((Option)this.currentScope$1.elem, VCD$.MODULE$.firrtl_interpreter$vcd$VCD$$scopePathString$default$2$1()), this.varName$1, BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}));
                            }
                            {
                                this.words$1 = words$1;
                                this.currentScope$1 = currentScope$1;
                                this.varName$1 = varName$1;
                            }
                        }));
                        skippedWires$1.update(idString, new Wire(varName, idString, new StringOps(Predef$.MODULE$.augmentString(sizeString)).toInt(), (String[])this.scopePath$1((Option)currentScope$1.elem).toArray(ClassTag$.MODULE$.apply(String.class))));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                } else {
                    String varName = (String)Predef$.MODULE$.refArrayOps((Object[])referenceString.split(" +")).head();
                    this.logger().debug((Function0<String>)((Object)new Serializable(words$1, currentScope$1, varName){
                        public static final long serialVersionUID = 0L;
                        private final VCD.WordIterator words$1;
                        private final ObjectRef currentScope$1;
                        private final String varName$2;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignore var ", "", " at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{VCD$.MODULE$.firrtl_interpreter$vcd$VCD$$scopePathString$1((Option)this.currentScope$1.elem, VCD$.MODULE$.firrtl_interpreter$vcd$VCD$$scopePathString$default$2$1()), this.varName$2, BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}));
                        }
                        {
                            this.words$1 = words$1;
                            this.currentScope$1 = currentScope$1;
                            this.varName$2 = varName$2;
                        }
                    }));
                    skippedWires$1.update(idString, new Wire(varName, idString, new StringOps(Predef$.MODULE$.augmentString(sizeString)).toInt(), (String[])this.scopePath$1((Option)currentScope$1.elem).toArray(ClassTag$.MODULE$.apply(String.class))));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        this.logger().warn((Function0<String>)((Object)new Serializable(words$1, s2){
            public static final long serialVersionUID = 0L;
            private final VCD.WordIterator words$1;
            private final String s$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not parse var ", " at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.s$1, BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}));
            }
            {
                this.words$1 = words$1;
                this.s$1 = s$1;
            }
        }));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final void processVar$1(String varPrefix$1, String newVarPrefix$1, VCD.WordIterator words$1, StringBuilder currentVar$1, ObjectRef currentScope$1, BooleanRef desiredScopeFound$1, HashMap wires$1, HashMap aliasedWires$1, HashMap skippedWires$1) {
        block2: {
            BoxedUnit boxedUnit;
            while (words$1.hasNext()) {
                String string2 = words$1.next();
                Option<List<String>> option2 = this.EndSection().unapplySeq(string2);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0) {
                    this.addVar$1(currentVar$1.toString(), varPrefix$1, newVarPrefix$1, words$1, currentScope$1, desiredScopeFound$1, wires$1, aliasedWires$1, skippedWires$1);
                    currentVar$1.clear();
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                currentVar$1.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{string2})));
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void processHeader$1(StringBuilder builder, VCD.WordIterator words$1) {
        block3: {
            BoxedUnit boxedUnit;
            while (words$1.hasNext()) {
                boolean bl;
                String string2 = words$1.next();
                Option<List<String>> option2 = this.EndSection().unapplySeq(string2);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(0) == 0) {
                    bl = false;
                } else {
                    builder.append(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{string2})));
                    bl = true;
                }
                if (bl) continue;
                boxedUnit = BoxedUnit.UNIT;
                break block3;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void processDump$1(VCD.WordIterator words$1, Map supportedVectorRadix$1, HashMap wires$1, LongRef currentTime$1, HashMap valuesAtTime$1, HashSet initialValues$1) {
        while (words$1.hasNext()) {
            BoxedUnit boxedUnit;
            String nextWord;
            String string2 = nextWord = words$1.next();
            Option<List<String>> option2 = this.ValueChangeScalar().unapplySeq(string2);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                Object object;
                String value2 = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String varCode = (String)((LinearSeqOptimized)option2.get()).apply(1);
                if (wires$1.contains(varCode)) {
                    this.logger().debug((Function0<String>)((Object)new Serializable(words$1, wires$1, value2, varCode){
                        public static final long serialVersionUID = 0L;
                        private final VCD.WordIterator words$1;
                        private final HashMap wires$1;
                        private final String value$2;
                        private final String varCode$1;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Change scalar ", " ", " at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.wires$1.apply(this.varCode$1), package$.MODULE$.BigInt().apply(this.value$2), BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}));
                        }
                        {
                            this.words$1 = words$1;
                            this.wires$1 = wires$1;
                            this.value$2 = value$2;
                            this.varCode$1 = varCode$1;
                        }
                    }));
                    object = BigInt$.MODULE$.long2bigInt(currentTime$1.elem).$less(package$.MODULE$.BigInt().apply(0)) ? initialValues$1.$plus$eq(new Change((Wire)wires$1.apply(varCode), package$.MODULE$.BigInt().apply(value2))) : ((HashSet)valuesAtTime$1.apply(BoxesRunTime.boxToLong(currentTime$1.elem))).$plus$eq(new Change((Wire)wires$1.apply(varCode), package$.MODULE$.BigInt().apply(value2)));
                } else {
                    this.logger().warn((Function0<String>)((Object)new Serializable(words$1, varCode){
                        public static final long serialVersionUID = 0L;
                        private final VCD.WordIterator words$1;
                        private final String varCode$1;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found change value for ", " but this key not defined  at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.varCode$1, BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}));
                        }
                        {
                            this.words$1 = words$1;
                            this.varCode$1 = varCode$1;
                        }
                    }));
                    object = BoxedUnit.UNIT;
                }
                boxedUnit = object;
                continue;
            }
            Option<List<String>> option3 = this.ValueChangeVector().unapplySeq(string2);
            if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                BoxedUnit boxedUnit2;
                String radixString = (String)((LinearSeqOptimized)option3.get()).apply(0);
                String value3 = (String)((LinearSeqOptimized)option3.get()).apply(1);
                if (words$1.hasNext()) {
                    String varCode = words$1.next();
                    if (wires$1.contains(varCode)) {
                        Object object;
                        Option option4 = supportedVectorRadix$1.get(radixString);
                        if (option4 instanceof Some) {
                            Some some2 = (Some)option4;
                            int radix = BoxesRunTime.unboxToInt(some2.x());
                            object = BigInt$.MODULE$.long2bigInt(currentTime$1.elem).$less(package$.MODULE$.BigInt().apply(0)) ? initialValues$1.$plus$eq(new Change((Wire)wires$1.apply(varCode), package$.MODULE$.BigInt().apply(value3, radix))) : ((HashSet)valuesAtTime$1.apply(BoxesRunTime.boxToLong(currentTime$1.elem))).$plus$eq(new Change((Wire)wires$1.apply(varCode), package$.MODULE$.BigInt().apply(value3, radix)));
                        } else {
                            if (!None$.MODULE$.equals(option4)) throw new MatchError(option4);
                            this.logger().warn((Function0<String>)((Object)new Serializable(words$1, radixString, varCode){
                                public static final long serialVersionUID = 0L;
                                private final VCD.WordIterator words$1;
                                private final String radixString$1;
                                private final String varCode$2;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found change value for ", " but "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.varCode$2}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"radix ", " not supported at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.radixString$1, BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}))).toString();
                                }
                                {
                                    this.words$1 = words$1;
                                    this.radixString$1 = radixString$1;
                                    this.varCode$2 = varCode$2;
                                }
                            }));
                            object = BoxedUnit.UNIT;
                        }
                        boxedUnit2 = object;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            Option<List<String>> option5 = this.ValueChangeVectorX().unapplySeq(string2);
            if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(1) == 0) {
                BoxedUnit boxedUnit3;
                String radixString = (String)((LinearSeqOptimized)option5.get()).apply(0);
                if (words$1.hasNext()) {
                    String varCode = words$1.next();
                    if (wires$1.contains(varCode)) {
                        Object object;
                        Option option6 = supportedVectorRadix$1.get(radixString);
                        if (option6 instanceof Some) {
                            object = BigInt$.MODULE$.long2bigInt(currentTime$1.elem).$less(package$.MODULE$.BigInt().apply(0)) ? initialValues$1.$plus$eq(new Change((Wire)wires$1.apply(varCode), package$.MODULE$.BigInt().apply(-1))) : ((HashSet)valuesAtTime$1.apply(BoxesRunTime.boxToLong(currentTime$1.elem))).$plus$eq(new Change((Wire)wires$1.apply(varCode), package$.MODULE$.BigInt().apply(-1)));
                        } else {
                            if (!None$.MODULE$.equals(option6)) throw new MatchError(option6);
                            this.logger().warn((Function0<String>)((Object)new Serializable(words$1, radixString, varCode){
                                public static final long serialVersionUID = 0L;
                                private final VCD.WordIterator words$1;
                                private final String radixString$2;
                                private final String varCode$3;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found change value for ", " but "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.varCode$3}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"radix ", " not supported at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.radixString$2, BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}))).toString();
                                }
                                {
                                    this.words$1 = words$1;
                                    this.radixString$2 = radixString$2;
                                    this.varCode$3 = varCode$3;
                                }
                            }));
                            object = BoxedUnit.UNIT;
                        }
                        boxedUnit3 = object;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit3;
                continue;
            }
            Option<List<String>> option7 = this.TimeStamp().unapplySeq(string2);
            if (!option7.isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(1) == 0) {
                String timeValue = (String)((LinearSeqOptimized)option7.get()).apply(0);
                currentTime$1.elem = new StringOps(Predef$.MODULE$.augmentString(timeValue)).toLong();
                this.logger().debug((Function0<String>)((Object)new Serializable(words$1, currentTime$1){
                    public static final long serialVersionUID = 0L;
                    private final VCD.WordIterator words$1;
                    private final LongRef currentTime$1;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"current time now ", " at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.currentTime$1.elem), BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}));
                    }
                    {
                        this.words$1 = words$1;
                        this.currentTime$1 = currentTime$1;
                    }
                }));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            Option<List<String>> option8 = this.EndSection().unapplySeq(string2);
            if (!option8.isEmpty() && option8.get() != null && ((LinearSeqOptimized)option8.get()).lengthCompare(0) == 0) {
                this.logger().debug((Function0<String>)((Object)new Serializable(words$1){
                    public static final long serialVersionUID = 0L;
                    private final VCD.WordIterator words$1;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"end of dump at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}));
                    }
                    {
                        this.words$1 = words$1;
                    }
                }));
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private final void processSections$1(String startScope$1, String renameStartScope$1, String varPrefix$1, String newVarPrefix$1, VCD.WordIterator words$1, StringBuilder dateHeader$1, StringBuilder versionHeader$1, StringBuilder commentHeader$1, StringBuilder timeScaleHeader$1, StringBuilder scopeBuffer$1, StringBuilder endDefinition$1, StringBuilder currentVar$1, ObjectRef scopeRoot$1, ObjectRef currentScope$1, BooleanRef desiredScopeFound$1, Map supportedVectorRadix$1, HashMap wires$1, HashMap aliasedWires$1, HashMap skippedWires$1, LongRef currentTime$1, HashMap valuesAtTime$1, HashSet initialValues$1) {
        while (words$1.hasNext()) {
            BoxedUnit boxedUnit;
            String nextWord;
            String string2 = nextWord = words$1.next();
            Option<List<String>> option2 = this.SectionHeader().unapplySeq(string2);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                BoxedUnit boxedUnit2;
                String sectionHeader = (String)((LinearSeqOptimized)option2.get()).apply(0);
                this.logger().debug((Function0<String>)((Object)new Serializable(words$1, sectionHeader){
                    public static final long serialVersionUID = 0L;
                    private final VCD.WordIterator words$1;
                    private final String sectionHeader$1;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"processing section header ", " at line ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.sectionHeader$1, BoxesRunTime.boxToInteger(this.words$1.currentLineNumber())}));
                    }
                    {
                        this.words$1 = words$1;
                        this.sectionHeader$1 = sectionHeader$1;
                    }
                }));
                String string3 = sectionHeader;
                if ("date".equals(string3)) {
                    this.processHeader$1(dateHeader$1, words$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("version".equals(string3)) {
                    this.processHeader$1(versionHeader$1, words$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("comment".equals(string3)) {
                    this.processHeader$1(commentHeader$1, words$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("timescale".equals(string3)) {
                    this.processHeader$1(timeScaleHeader$1, words$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("scope".equals(string3)) {
                    this.processScope$1(startScope$1, renameStartScope$1, words$1, scopeBuffer$1, scopeRoot$1, currentScope$1, desiredScopeFound$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("upscope".equals(string3)) {
                    this.processUpScope$1(startScope$1, renameStartScope$1, words$1, scopeBuffer$1, scopeRoot$1, currentScope$1, desiredScopeFound$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("var".equals(string3)) {
                    this.processVar$1(varPrefix$1, newVarPrefix$1, words$1, currentVar$1, currentScope$1, desiredScopeFound$1, wires$1, aliasedWires$1, skippedWires$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("enddefinitions".equals(string3)) {
                    this.processHeader$1(endDefinition$1, words$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if ("dumpvars".equals(string3)) {
                    this.processDump$1(words$1, supportedVectorRadix$1, wires$1, currentTime$1, valuesAtTime$1, initialValues$1);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            this.processDump$1(words$1, supportedVectorRadix$1, wires$1, currentTime$1, valuesAtTime$1, initialValues$1);
            this.logger().debug((Function0<String>)((Object)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "skipping at line ${words.currentLineNumber}";
                }
            }));
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private VCD$() {
        MODULE$ = this;
        LazyLogging$class.$init$(this);
        this.Version = "0.2";
        this.DateDeclaration = "$date";
        this.VersionDeclaration = "$version";
        this.CommentDeclaration = "$comment";
        this.TimeScaleDeclaration = "$timescale";
        this.ScopeDeclaration = "$scope";
        this.VarDeclaration = "$var";
        this.UpScopeDeclaration = "$upscope";
        this.EndDefinitionsDeclaration = "$enddefinitions";
        this.DumpVarsDeclaration = "$dumpvars";
        this.End = "$end";
        this.firrtl_interpreter$vcd$VCD$$ClockName = "clock";
        this.ResetName = "reset";
        this.idChars = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(33), 126).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(int asciiValue) {
                return ((Object)BoxesRunTime.boxToCharacter((char)asciiValue)).toString();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.numberOfIdChars = this.idChars().length();
        this.SectionHeader = new StringOps(Predef$.MODULE$.augmentString("^\\$([^\\$]+) *$")).r();
        this.EndSection = new StringOps(Predef$.MODULE$.augmentString("^\\$end *$")).r();
        this.ScopedModule = new StringOps(Predef$.MODULE$.augmentString("\\s*(?i)(\\S+)\\s+(\\S+)\\s*")).r();
        this.JustScoped = new StringOps(Predef$.MODULE$.augmentString("\\s*(\\S+)\\s*")).r();
        this.VarSpec = new StringOps(Predef$.MODULE$.augmentString("\\s*(\\w+)\\s+(\\d+)\\s+(\\S+)\\s+([\\S ]+)\\s*")).r();
        this.ValueChangeScalar = new StringOps(Predef$.MODULE$.augmentString("\\s*(\\d+)(\\S+)\\s*")).r();
        this.ValueChangeVector = new StringOps(Predef$.MODULE$.augmentString("\\s*([rbh])([0-9\\.]+)\\s*")).r();
        this.ValueChangeVectorX = new StringOps(Predef$.MODULE$.augmentString("\\s*([rbh]).*x.*\\s*")).r();
        this.TimeStamp = new StringOps(Predef$.MODULE$.augmentString("\\s*#(\\d+)\\s*")).r();
    }
}

