/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.representer;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.representer.BaseRepresenter;
import org.yaml.snakeyaml.representer.Represent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SafeRepresenter
extends BaseRepresenter {
    protected Map<Class<? extends Object>, Tag> classTags;
    protected TimeZone timeZone = null;
    public static Pattern MULTILINE_PATTERN = Pattern.compile("\n|\u0085|\u2028|\u2029");

    public SafeRepresenter() {
        this.nullRepresenter = new RepresentNull();
        this.representers.put(String.class, new RepresentString());
        this.representers.put(Boolean.class, new RepresentBoolean());
        this.representers.put(Character.class, new RepresentString());
        this.representers.put(UUID.class, new RepresentUuid());
        this.representers.put(byte[].class, new RepresentByteArray());
        RepresentPrimitiveArray primitiveArray = new RepresentPrimitiveArray();
        this.representers.put(short[].class, primitiveArray);
        this.representers.put(int[].class, primitiveArray);
        this.representers.put(long[].class, primitiveArray);
        this.representers.put(float[].class, primitiveArray);
        this.representers.put(double[].class, primitiveArray);
        this.representers.put(char[].class, primitiveArray);
        this.representers.put(boolean[].class, primitiveArray);
        this.multiRepresenters.put(Number.class, new RepresentNumber());
        this.multiRepresenters.put(List.class, new RepresentList());
        this.multiRepresenters.put(Map.class, new RepresentMap());
        this.multiRepresenters.put(Set.class, new RepresentSet());
        this.multiRepresenters.put(Iterator.class, new RepresentIterator());
        this.multiRepresenters.put(new Object[0].getClass(), new RepresentArray());
        this.multiRepresenters.put(Date.class, new RepresentDate());
        this.multiRepresenters.put(Enum.class, new RepresentEnum());
        this.multiRepresenters.put(Calendar.class, new RepresentDate());
        this.classTags = new HashMap<Class<? extends Object>, Tag>();
    }

    protected Tag getTag(Class<?> clazz, Tag defaultTag) {
        if (this.classTags.containsKey(clazz)) {
            return this.classTags.get(clazz);
        }
        return defaultTag;
    }

    public Tag addClassTag(Class<? extends Object> clazz, Tag tag) {
        if (tag == null) {
            throw new NullPointerException("Tag must be provided.");
        }
        return this.classTags.put(clazz, tag);
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    protected class RepresentUuid
    implements Represent {
        protected RepresentUuid() {
        }

        public Node representData(Object data) {
            return SafeRepresenter.this.representScalar(SafeRepresenter.this.getTag(data.getClass(), new Tag(UUID.class)), data.toString());
        }
    }

    protected class RepresentByteArray
    implements Represent {
        protected RepresentByteArray() {
        }

        public Node representData(Object data) {
            char[] binary = Base64Coder.encode((byte[])data);
            return SafeRepresenter.this.representScalar(Tag.BINARY, String.valueOf(binary), Character.valueOf('|'));
        }
    }

    protected class RepresentEnum
    implements Represent {
        protected RepresentEnum() {
        }

        public Node representData(Object data) {
            Tag tag = new Tag(data.getClass());
            return SafeRepresenter.this.representScalar(SafeRepresenter.this.getTag(data.getClass(), tag), ((Enum)data).name());
        }
    }

    protected class RepresentDate
    implements Represent {
        protected RepresentDate() {
        }

        public Node representData(Object data) {
            Calendar calendar;
            if (data instanceof Calendar) {
                calendar = (Calendar)data;
            } else {
                calendar = Calendar.getInstance(SafeRepresenter.this.getTimeZone() == null ? TimeZone.getTimeZone("UTC") : SafeRepresenter.this.timeZone);
                calendar.setTime((Date)data);
            }
            int years = calendar.get(1);
            int months = calendar.get(2) + 1;
            int days = calendar.get(5);
            int hour24 = calendar.get(11);
            int minutes = calendar.get(12);
            int seconds = calendar.get(13);
            int millis = calendar.get(14);
            StringBuilder buffer2 = new StringBuilder(String.valueOf(years));
            while (buffer2.length() < 4) {
                buffer2.insert(0, "0");
            }
            buffer2.append("-");
            if (months < 10) {
                buffer2.append("0");
            }
            buffer2.append(String.valueOf(months));
            buffer2.append("-");
            if (days < 10) {
                buffer2.append("0");
            }
            buffer2.append(String.valueOf(days));
            buffer2.append("T");
            if (hour24 < 10) {
                buffer2.append("0");
            }
            buffer2.append(String.valueOf(hour24));
            buffer2.append(":");
            if (minutes < 10) {
                buffer2.append("0");
            }
            buffer2.append(String.valueOf(minutes));
            buffer2.append(":");
            if (seconds < 10) {
                buffer2.append("0");
            }
            buffer2.append(String.valueOf(seconds));
            if (millis > 0) {
                if (millis < 10) {
                    buffer2.append(".00");
                } else if (millis < 100) {
                    buffer2.append(".0");
                } else {
                    buffer2.append(".");
                }
                buffer2.append(String.valueOf(millis));
            }
            if (TimeZone.getTimeZone("UTC").equals(calendar.getTimeZone())) {
                buffer2.append("Z");
            } else {
                int gmtOffset = calendar.getTimeZone().getOffset(calendar.get(0), calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(7), calendar.get(14));
                int minutesOffset = gmtOffset / 60000;
                int hoursOffset = minutesOffset / 60;
                int partOfHour = minutesOffset % 60;
                buffer2.append((hoursOffset > 0 ? "+" : "") + hoursOffset + ":" + (partOfHour < 10 ? "0" + partOfHour : Integer.valueOf(partOfHour)));
            }
            return SafeRepresenter.this.representScalar(SafeRepresenter.this.getTag(data.getClass(), Tag.TIMESTAMP), buffer2.toString(), null);
        }
    }

    protected class RepresentSet
    implements Represent {
        protected RepresentSet() {
        }

        public Node representData(Object data) {
            LinkedHashMap value2 = new LinkedHashMap();
            Set set2 = (Set)data;
            for (Object key2 : set2) {
                value2.put(key2, null);
            }
            return SafeRepresenter.this.representMapping(SafeRepresenter.this.getTag(data.getClass(), Tag.SET), value2, null);
        }
    }

    protected class RepresentMap
    implements Represent {
        protected RepresentMap() {
        }

        public Node representData(Object data) {
            return SafeRepresenter.this.representMapping(SafeRepresenter.this.getTag(data.getClass(), Tag.MAP), (Map)data, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RepresentPrimitiveArray
    implements Represent {
        protected RepresentPrimitiveArray() {
        }

        @Override
        public Node representData(Object data) {
            Class<?> type = data.getClass().getComponentType();
            if (Byte.TYPE == type) {
                return SafeRepresenter.this.representSequence(Tag.SEQ, this.asByteList(data), null);
            }
            if (Short.TYPE == type) {
                return SafeRepresenter.this.representSequence(Tag.SEQ, this.asShortList(data), null);
            }
            if (Integer.TYPE == type) {
                return SafeRepresenter.this.representSequence(Tag.SEQ, this.asIntList(data), null);
            }
            if (Long.TYPE == type) {
                return SafeRepresenter.this.representSequence(Tag.SEQ, this.asLongList(data), null);
            }
            if (Float.TYPE == type) {
                return SafeRepresenter.this.representSequence(Tag.SEQ, this.asFloatList(data), null);
            }
            if (Double.TYPE == type) {
                return SafeRepresenter.this.representSequence(Tag.SEQ, this.asDoubleList(data), null);
            }
            if (Character.TYPE == type) {
                return SafeRepresenter.this.representSequence(Tag.SEQ, this.asCharList(data), null);
            }
            if (Boolean.TYPE == type) {
                return SafeRepresenter.this.representSequence(Tag.SEQ, this.asBooleanList(data), null);
            }
            throw new YAMLException("Unexpected primitive '" + type.getCanonicalName() + "'");
        }

        private List<Byte> asByteList(Object in) {
            byte[] array = (byte[])in;
            ArrayList<Byte> list2 = new ArrayList<Byte>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list2.add(array[i]);
            }
            return list2;
        }

        private List<Short> asShortList(Object in) {
            short[] array = (short[])in;
            ArrayList<Short> list2 = new ArrayList<Short>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list2.add(array[i]);
            }
            return list2;
        }

        private List<Integer> asIntList(Object in) {
            int[] array = (int[])in;
            ArrayList<Integer> list2 = new ArrayList<Integer>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list2.add(array[i]);
            }
            return list2;
        }

        private List<Long> asLongList(Object in) {
            long[] array = (long[])in;
            ArrayList<Long> list2 = new ArrayList<Long>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list2.add(array[i]);
            }
            return list2;
        }

        private List<Float> asFloatList(Object in) {
            float[] array = (float[])in;
            ArrayList<Float> list2 = new ArrayList<Float>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list2.add(Float.valueOf(array[i]));
            }
            return list2;
        }

        private List<Double> asDoubleList(Object in) {
            double[] array = (double[])in;
            ArrayList<Double> list2 = new ArrayList<Double>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list2.add(array[i]);
            }
            return list2;
        }

        private List<Character> asCharList(Object in) {
            char[] array = (char[])in;
            ArrayList<Character> list2 = new ArrayList<Character>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list2.add(Character.valueOf(array[i]));
            }
            return list2;
        }

        private List<Boolean> asBooleanList(Object in) {
            boolean[] array = (boolean[])in;
            ArrayList<Boolean> list2 = new ArrayList<Boolean>(array.length);
            for (int i = 0; i < array.length; ++i) {
                list2.add(array[i]);
            }
            return list2;
        }
    }

    protected class RepresentArray
    implements Represent {
        protected RepresentArray() {
        }

        public Node representData(Object data) {
            Object[] array = (Object[])data;
            List<Object> list2 = Arrays.asList(array);
            return SafeRepresenter.this.representSequence(Tag.SEQ, list2, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IteratorWrapper
    implements Iterable<Object> {
        private Iterator<Object> iter;

        public IteratorWrapper(Iterator<Object> iter2) {
            this.iter = iter2;
        }

        @Override
        public Iterator<Object> iterator() {
            return this.iter;
        }
    }

    protected class RepresentIterator
    implements Represent {
        protected RepresentIterator() {
        }

        public Node representData(Object data) {
            Iterator iter2 = (Iterator)data;
            return SafeRepresenter.this.representSequence(SafeRepresenter.this.getTag(data.getClass(), Tag.SEQ), new IteratorWrapper(iter2), null);
        }
    }

    protected class RepresentList
    implements Represent {
        protected RepresentList() {
        }

        public Node representData(Object data) {
            return SafeRepresenter.this.representSequence(SafeRepresenter.this.getTag(data.getClass(), Tag.SEQ), (List)data, null);
        }
    }

    protected class RepresentNumber
    implements Represent {
        protected RepresentNumber() {
        }

        public Node representData(Object data) {
            String value2;
            Tag tag;
            if (data instanceof Byte || data instanceof Short || data instanceof Integer || data instanceof Long || data instanceof BigInteger) {
                tag = Tag.INT;
                value2 = data.toString();
            } else {
                Number number2 = (Number)data;
                tag = Tag.FLOAT;
                value2 = number2.equals(Double.NaN) ? ".NaN" : (number2.equals(Double.POSITIVE_INFINITY) ? ".inf" : (number2.equals(Double.NEGATIVE_INFINITY) ? "-.inf" : number2.toString()));
            }
            return SafeRepresenter.this.representScalar(SafeRepresenter.this.getTag(data.getClass(), tag), value2);
        }
    }

    protected class RepresentBoolean
    implements Represent {
        protected RepresentBoolean() {
        }

        public Node representData(Object data) {
            String value2 = Boolean.TRUE.equals(data) ? "true" : "false";
            return SafeRepresenter.this.representScalar(Tag.BOOL, value2);
        }
    }

    protected class RepresentString
    implements Represent {
        protected RepresentString() {
        }

        public Node representData(Object data) {
            Tag tag = Tag.STR;
            Character style = null;
            String value2 = data.toString();
            if (StreamReader.NON_PRINTABLE.matcher(value2).find()) {
                char[] binary;
                tag = Tag.BINARY;
                try {
                    binary = Base64Coder.encode(value2.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new YAMLException(e);
                }
                value2 = String.valueOf(binary);
                style = Character.valueOf('|');
            }
            if (SafeRepresenter.this.defaultScalarStyle == null && MULTILINE_PATTERN.matcher(value2).find()) {
                style = Character.valueOf('|');
            }
            return SafeRepresenter.this.representScalar(tag, value2, style);
        }
    }

    protected class RepresentNull
    implements Represent {
        protected RepresentNull() {
        }

        public Node representData(Object data) {
            return SafeRepresenter.this.representScalar(Tag.NULL, "null");
        }
    }
}

