/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline.console.completer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import scala.tools.jline.console.completer.Completer;
import scala.tools.jline.internal.Preconditions;

public class AggregateCompleter
implements Completer {
    private final List<Completer> completers = new ArrayList<Completer>();

    public AggregateCompleter() {
    }

    public AggregateCompleter(Collection<Completer> completers) {
        Preconditions.checkNotNull(completers);
        this.completers.addAll(completers);
    }

    public AggregateCompleter(Completer ... completers) {
        this(Arrays.asList(completers));
    }

    public Collection<Completer> getCompleters() {
        return this.completers;
    }

    @Override
    public int complete(String buffer2, int cursor, List<CharSequence> candidates) {
        Preconditions.checkNotNull(candidates);
        ArrayList<Completion> completions = new ArrayList<Completion>(this.completers.size());
        int max2 = -1;
        for (Completer completer : this.completers) {
            Completion completion = new Completion(candidates);
            completion.complete(completer, buffer2, cursor);
            max2 = Math.max(max2, completion.cursor);
            completions.add(completion);
        }
        for (Completion completion : completions) {
            if (completion.cursor != max2) continue;
            candidates.addAll(completion.candidates);
        }
        return max2;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "completers=" + this.completers + '}';
    }

    private class Completion {
        public final List<CharSequence> candidates;
        public int cursor;

        public Completion(List<CharSequence> candidates) {
            Preconditions.checkNotNull(candidates);
            this.candidates = new LinkedList<CharSequence>(candidates);
        }

        public void complete(Completer completer, String buffer2, int cursor) {
            Preconditions.checkNotNull(completer);
            this.cursor = completer.complete(buffer2, cursor, this.candidates);
        }
    }
}

