/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.jline.console.completer;

import java.io.File;
import java.util.List;
import scala.tools.jline.console.completer.Completer;
import scala.tools.jline.internal.Configuration;
import scala.tools.jline.internal.Preconditions;

public class FileNameCompleter
implements Completer {
    private static final boolean OS_IS_WINDOWS;

    @Override
    public int complete(String buffer2, int cursor, List<CharSequence> candidates) {
        Preconditions.checkNotNull(candidates);
        if (buffer2 == null) {
            buffer2 = "";
        }
        if (OS_IS_WINDOWS) {
            buffer2 = buffer2.replace('/', '\\');
        }
        String translated = buffer2;
        File homeDir = this.getUserHome();
        if (translated.startsWith("~" + this.separator())) {
            translated = homeDir.getPath() + translated.substring(1);
        } else if (translated.startsWith("~")) {
            translated = homeDir.getParentFile().getAbsolutePath();
        } else if (!new File(translated).isAbsolute()) {
            String cwd = this.getUserDir().getAbsolutePath();
            translated = cwd + this.separator() + translated;
        }
        File file = new File(translated);
        File dir = translated.endsWith(this.separator()) ? file : file.getParentFile();
        File[] entries = dir == null ? new File[]{} : dir.listFiles();
        return this.matchFiles(buffer2, translated, entries, candidates);
    }

    protected String separator() {
        return File.separator;
    }

    protected File getUserHome() {
        return Configuration.getUserHome();
    }

    protected File getUserDir() {
        return new File(".");
    }

    protected int matchFiles(String buffer2, String translated, File[] files2, List<CharSequence> candidates) {
        if (files2 == null) {
            return -1;
        }
        int matches = 0;
        for (File file : files2) {
            if (!file.getAbsolutePath().startsWith(translated)) continue;
            ++matches;
        }
        for (File file : files2) {
            if (!file.getAbsolutePath().startsWith(translated)) continue;
            String name2 = file.getName() + (matches == 1 && file.isDirectory() ? this.separator() : " ");
            candidates.add(((Object)this.render(file, name2)).toString());
        }
        int index2 = buffer2.lastIndexOf(this.separator());
        return index2 + this.separator().length();
    }

    protected CharSequence render(File file, CharSequence name2) {
        return name2;
    }

    static {
        String os = Configuration.getOsName();
        OS_IS_WINDOWS = os.contains("windows");
    }
}

