//
// Copyright (C) 2014 David de la Chevallerie, TU Darmstadt
//
// This file is part of Tapasco (TPC).
//
// Tapasco is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tapasco is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with Tapasco.  If not, see <http://www.gnu.org/licenses/>.
//
/**
 * @file device_user.h
 * @brief Composition of everything needed for the char-device(s) for user-calls
	Functions to (un/)load this device and interrupt handlers
	these handlers will be registered as msi irqs, when the pcie_device is loaded
 * */

#ifndef __DEVICE_USER_H
#define __DEVICE_USER_H

/******************************************************************************/
/* helper functions called to (un/)load this char device */

int char_user_register(void);
void char_user_unregister(void);

/******************************************************************************/
/* interrupt handler used by user cores registered in pcie_device.c */

#define DECLARE_INTR_HANDLER_USER(nr) irqreturn_t intr_handler_user_ ## nr(int irq, void * dev_id)

DECLARE_INTR_HANDLER_USER(0);
DECLARE_INTR_HANDLER_USER(1);
DECLARE_INTR_HANDLER_USER(2);
DECLARE_INTR_HANDLER_USER(3);
DECLARE_INTR_HANDLER_USER(4);
DECLARE_INTR_HANDLER_USER(5);
DECLARE_INTR_HANDLER_USER(6);
DECLARE_INTR_HANDLER_USER(7);
DECLARE_INTR_HANDLER_USER(8);
DECLARE_INTR_HANDLER_USER(9);
DECLARE_INTR_HANDLER_USER(10);
DECLARE_INTR_HANDLER_USER(11);
DECLARE_INTR_HANDLER_USER(12);
DECLARE_INTR_HANDLER_USER(13);
DECLARE_INTR_HANDLER_USER(14);
DECLARE_INTR_HANDLER_USER(15);
DECLARE_INTR_HANDLER_USER(16);
DECLARE_INTR_HANDLER_USER(17);
DECLARE_INTR_HANDLER_USER(18);
DECLARE_INTR_HANDLER_USER(19);
DECLARE_INTR_HANDLER_USER(20);
DECLARE_INTR_HANDLER_USER(21);
DECLARE_INTR_HANDLER_USER(22);
DECLARE_INTR_HANDLER_USER(23);
DECLARE_INTR_HANDLER_USER(24);
DECLARE_INTR_HANDLER_USER(25);
DECLARE_INTR_HANDLER_USER(26);
DECLARE_INTR_HANDLER_USER(27);
DECLARE_INTR_HANDLER_USER(28);
DECLARE_INTR_HANDLER_USER(29);
DECLARE_INTR_HANDLER_USER(30);
DECLARE_INTR_HANDLER_USER(31);
DECLARE_INTR_HANDLER_USER(32);
DECLARE_INTR_HANDLER_USER(33);
DECLARE_INTR_HANDLER_USER(34);
DECLARE_INTR_HANDLER_USER(35);
DECLARE_INTR_HANDLER_USER(36);
DECLARE_INTR_HANDLER_USER(37);
DECLARE_INTR_HANDLER_USER(38);
DECLARE_INTR_HANDLER_USER(39);
DECLARE_INTR_HANDLER_USER(40);
DECLARE_INTR_HANDLER_USER(41);
DECLARE_INTR_HANDLER_USER(42);
DECLARE_INTR_HANDLER_USER(43);
DECLARE_INTR_HANDLER_USER(44);
DECLARE_INTR_HANDLER_USER(45);
DECLARE_INTR_HANDLER_USER(46);
DECLARE_INTR_HANDLER_USER(47);
DECLARE_INTR_HANDLER_USER(48);
DECLARE_INTR_HANDLER_USER(49);
DECLARE_INTR_HANDLER_USER(50);
DECLARE_INTR_HANDLER_USER(51);
DECLARE_INTR_HANDLER_USER(52);
DECLARE_INTR_HANDLER_USER(53);
DECLARE_INTR_HANDLER_USER(54);
DECLARE_INTR_HANDLER_USER(55);
DECLARE_INTR_HANDLER_USER(56);
DECLARE_INTR_HANDLER_USER(57);
DECLARE_INTR_HANDLER_USER(58);
DECLARE_INTR_HANDLER_USER(59);
DECLARE_INTR_HANDLER_USER(60);
DECLARE_INTR_HANDLER_USER(61);
DECLARE_INTR_HANDLER_USER(62);
DECLARE_INTR_HANDLER_USER(63);
DECLARE_INTR_HANDLER_USER(64);
DECLARE_INTR_HANDLER_USER(65);
DECLARE_INTR_HANDLER_USER(66);
DECLARE_INTR_HANDLER_USER(67);
DECLARE_INTR_HANDLER_USER(68);
DECLARE_INTR_HANDLER_USER(69);
DECLARE_INTR_HANDLER_USER(70);
DECLARE_INTR_HANDLER_USER(71);
DECLARE_INTR_HANDLER_USER(72);
DECLARE_INTR_HANDLER_USER(73);
DECLARE_INTR_HANDLER_USER(74);
DECLARE_INTR_HANDLER_USER(75);
DECLARE_INTR_HANDLER_USER(76);
DECLARE_INTR_HANDLER_USER(77);
DECLARE_INTR_HANDLER_USER(78);
DECLARE_INTR_HANDLER_USER(79);
DECLARE_INTR_HANDLER_USER(80);
DECLARE_INTR_HANDLER_USER(81);
DECLARE_INTR_HANDLER_USER(82);
DECLARE_INTR_HANDLER_USER(83);
DECLARE_INTR_HANDLER_USER(84);
DECLARE_INTR_HANDLER_USER(85);
DECLARE_INTR_HANDLER_USER(86);
DECLARE_INTR_HANDLER_USER(87);
DECLARE_INTR_HANDLER_USER(88);
DECLARE_INTR_HANDLER_USER(89);
DECLARE_INTR_HANDLER_USER(90);
DECLARE_INTR_HANDLER_USER(91);
DECLARE_INTR_HANDLER_USER(92);
DECLARE_INTR_HANDLER_USER(93);
DECLARE_INTR_HANDLER_USER(94);
DECLARE_INTR_HANDLER_USER(95);
DECLARE_INTR_HANDLER_USER(96);
DECLARE_INTR_HANDLER_USER(97);
DECLARE_INTR_HANDLER_USER(98);
DECLARE_INTR_HANDLER_USER(99);
DECLARE_INTR_HANDLER_USER(100);
DECLARE_INTR_HANDLER_USER(101);
DECLARE_INTR_HANDLER_USER(102);
DECLARE_INTR_HANDLER_USER(103);
DECLARE_INTR_HANDLER_USER(104);
DECLARE_INTR_HANDLER_USER(105);
DECLARE_INTR_HANDLER_USER(106);
DECLARE_INTR_HANDLER_USER(107);
DECLARE_INTR_HANDLER_USER(108);
DECLARE_INTR_HANDLER_USER(109);
DECLARE_INTR_HANDLER_USER(110);
DECLARE_INTR_HANDLER_USER(111);
DECLARE_INTR_HANDLER_USER(112);
DECLARE_INTR_HANDLER_USER(113);
DECLARE_INTR_HANDLER_USER(114);
DECLARE_INTR_HANDLER_USER(115);
DECLARE_INTR_HANDLER_USER(116);
DECLARE_INTR_HANDLER_USER(117);
DECLARE_INTR_HANDLER_USER(118);
DECLARE_INTR_HANDLER_USER(119);
DECLARE_INTR_HANDLER_USER(120);
DECLARE_INTR_HANDLER_USER(121);
DECLARE_INTR_HANDLER_USER(122);
DECLARE_INTR_HANDLER_USER(123);
DECLARE_INTR_HANDLER_USER(124);
DECLARE_INTR_HANDLER_USER(125);
DECLARE_INTR_HANDLER_USER(126);
DECLARE_INTR_HANDLER_USER(127);

/******************************************************************************/

#endif // __DEVICE_USER_H
