//
// Copyright (C) 2014 David de la Chevallerie, TU Darmstadt
//
// This file is part of Tapasco (TPC).
//
// Tapasco is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tapasco is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with Tapasco.  If not, see <http://www.gnu.org/licenses/>.
//
#include "logger.hpp"

// define global logging level
loglevel_e loglevel = logERROR;
// backup loglevel for local change
loglevel_e loglevel_last = logERROR;

void change_log_level(loglevel_e level) {
	loglevel_last = loglevel;
	loglevel = level;
}

void resume_log_level() {
	loglevel = loglevel_last;
}
