//
// Copyright (C) 2017 Jens Korinth, TU Darmstadt
//
// This file is part of Tapasco (TPC).
//
// Tapasco is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tapasco is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with Tapasco.  If not, see <http://www.gnu.org/licenses/>.
//
package de.tu_darmstadt.cs.esa.tapasco.itapasco.view.detail
import  de.tu_darmstadt.cs.esa.tapasco.itapasco.view.selection._
import  de.tu_darmstadt.cs.esa.tapasco.filemgmt.{Entity, Entities}
import  de.tu_darmstadt.cs.esa.tapasco.util.Listener
import  scala.swing.{Alignment, BorderPanel, Label, TextArea}
import  DirectoriesPanel.Events._
import  Entities._

/** Detail panel for a base path / directory.
 *  Shows an explanatory text for the role of the base path.
 */
class DirectoryDetailPanel extends BorderPanel with Listener[DirectoriesPanel.Event] {
  private val bg = background
  private[this] val desc = new TextArea() {
    text = ""
    editable = false
    wordWrap = true
    lineWrap = true
    background = bg
  }

  def update(e: DirectoriesPanel.Event): Unit = e match {
    case EntityPathSelected(e: Entity) =>
      desc.text = DirectoryDetailPanel.detailTexts(e)
      revalidate()
    case _ => {}
  }

  layout(new Label("Description:") {
    horizontalAlignment = Alignment.Left
  }) = BorderPanel.Position.North

  layout(desc) = BorderPanel.Position.Center
}

private object DirectoryDetailPanel {
  val detailTexts: Map[Entity, String] = Map(
    Architectures -> """
      Architecture directory - This is the directory in which TaPaSCo will
      look for files called architecture.json containing the JSON
      description of a TaPaSCo architecture (i.e., the organisation of the
      processing elements). Changing this directory will affect the
      available architectures in the 'Architectures' tab.
     """.trim.split("""\s+""").mkString(" "),
    Compositions -> """
      Composition directory - This is the output directory for the
      TaPaSCo hardware designs. It is organized in a three-level directory
      hierarchy: First level contains the composition + target
      user clock frequency pairs, second level the architecture and
      the third level the platform for all Compositions that were
      built with TaPaSCo. When a build is started, TPC will overwrite
      existing runs in this directory.
    """.trim.split("""\s+""").mkString(" "),
    Cores -> """
      Core Directory - This is the output directory for the processing
      elements (PEs) that were built by, or can be used by, TaPaSCo (i.e.,
      it contains the IP-XACT base.of the cores and the
      synthesis results. TaPaSCo will look here for synthesis results
      (e.g., area requirements, max. frequency, etc.) during design
      space exploration (DSE).
      It is organized in a three-level directory hierarchy: First
      level contains a directory for each distinct available core,
      second level contains one directory for each TaPaSCo architecture
      and the last level one directory for each TaPaSCo platform.
      Each core is described by a core.json file containing
      a JSON description of the core with the basic information that
      TaPaSCo requires to use the core as a PE in a ThreadPool.
      TaPaSCo will generate the base.automatically during
      high-level synthesis (HLS), but you can also provide it manually
      and place your custom core in this directory. All available
      cores will be shown in the 'Cores' tab.
    """.trim.split("""\s+""").mkString(" "),
    Kernels -> """
      Kernel directory - This is the directory in which TaPaSCo will look
      for kernel.json files containing the JSON description of
      a processing element (PE) that can be generated by a High-Level
      Synthesis (HLS) tool, such as Xilinx Vivado HLS. When selecting
      such a Kernel for the Composition, TaPaSCo will search the 'Core'
      directory for previous HLS results. If none are found, the core
      is built automatically prior to building the Composition.
    """.trim.split("""\s+""").mkString(" "),
    Platforms -> """
      Platform directory - This is the directory in which TaPaSCo will
      look for files called platform.json containing the
      JSON description of a TaPaSCo platform (i.e., the device-specific
      and infrastructure components).
      Changing this directory will affect the available platforms
      in the 'Platforms' tab.
     """.trim.split("""\s+""").mkString(" ")
  )
}
