//
// Copyright (C) 2017 Jens Korinth, TU Darmstadt
//
// This file is part of Tapasco (TPC).
//
// Tapasco is free software: you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tapasco is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with Tapasco.  If not, see <http://www.gnu.org/licenses/>.
//
package de.tu_darmstadt.cs.esa.tapasco.itapasco.view.dse.graph
import  de.tu_darmstadt.cs.esa.tapasco.itapasco.model._
import  de.tu_darmstadt.cs.esa.tapasco.itapasco.model.DesignSpaceGraph._
import  edu.uci.ics.jung.algorithms.layout.StaticLayout
import  java.awt.geom.Point2D
import  com.google.common.base.Function

/** Defines a static coordinate space for instances of [[model.DesignSpaceGraph]].
 *    - `X` is area utilization in percent
 *    - `Y` is negative of design frequency in MHz divided by 5
 *  The latter deserves explanation: The overall graph shape should be square;
 *  utilization ranges from 0-100 (in valid cases), while design frequencies range
 *  from 0-500 MHz, thus the rescaling.
 *
 *  @todo Need to extend frequency range for UltraScale(+) devices?
 *  @todo Check if this is the right package?
 *
 *  @constructor Create new instance.
 *  @param g [[model.DesignSpaceGraph]] to associate with.
 */
class DesignSpaceStaticLayout(g: DesignSpaceGraph) extends StaticLayout(g, new Function[N, Point2D] {
    def apply(e: N): Point2D = {
      val util = g.utilization(e) map (_.utilization)
      assert (util.nonEmpty, "area estimate must be available for all elements")
      new Point2D.Double(util getOrElse 0.0, -e.frequency / 5.0)
    } }) {
  // set all nodes locked
  override def isLocked(v: N): Boolean = true
  override def setLocation(v: N, location: Point2D): Unit = {}
}
